package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.dao.ResourcePageCollectDao;
import com.pcloud.book.group.entity.ResourcePageCollect;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @ClassName com.pcloud.book.group.dao.impl.ResourcePageCollectDaoImpl
 * @Author zhuyajie
 * @Description 资源页收藏记录
 * @Date 2021/4/26 15:28
 * @Version 1.0
 **/
@Component
public class ResourcePageCollectDaoImpl extends BaseDaoImpl<ResourcePageCollect> implements ResourcePageCollectDao {

    @Override
    public ResourcePageCollect getCollectRecordByUser(Long wechatUserId, Long resourcePageId) {
        Map<String, Object> map = new HashMap<>();
        map.put("wechatUserId", wechatUserId);
        map.put("resourcePageId", resourcePageId);
        return getSessionTemplate().selectOne(getStatement("getCollectRecordByUser"), map);
    }

    @Override
    public Integer getUserIsNotNew(Long wechatUserId) {
        return getSessionTemplate().selectOne(getStatement("getUserIsNotNew"), wechatUserId);
    }

    @Override
    public Integer getCollectStateByUser(Long wechatUserId, Long resourcePageId) {
        Map<String, Object> map = new HashMap<>();
        map.put("wechatUserId", wechatUserId);
        map.put("resourcePageId", resourcePageId);
        return getSessionTemplate().selectOne(getStatement("getCollectStateByUser"), map);
    }
}
