package com.pcloud.book.group.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/7/25 9:50
 **/
@ApiModel("学习报告")
public class UserLearningInfoDTO implements Serializable {
    private static final long serialVersionUID = 7734297462091875084L;

    @ApiModelProperty("微信id")
    private Long wechatUserId;

    @ApiModelProperty("昵称")
    private String nickName;

    @ApiModelProperty("头像")
    private String headUrl;

    @ApiModelProperty("元气值")
    private Integer score;

    @ApiModelProperty("总学习时长")
    private Integer allLearningTime;

    @ApiModelProperty("群排名")
    private Integer groupSort;

    @ApiModelProperty("超过群成员百分比")
    private Double exceedPercent;

    @ApiModelProperty("二维码链接")
    private String qrcodeUrl;

    public Long getWechatUserId() {
        return wechatUserId;
    }

    public void setWechatUserId(Long wechatUserId) {
        this.wechatUserId = wechatUserId;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getHeadUrl() {
        return headUrl;
    }

    public void setHeadUrl(String headUrl) {
        this.headUrl = headUrl;
    }

    public Integer getScore() {
        return score;
    }

    public void setScore(Integer score) {
        this.score = score;
    }

    public Integer getAllLearningTime() {
        return allLearningTime;
    }

    public void setAllLearningTime(Integer allLearningTime) {
        this.allLearningTime = allLearningTime;
    }

    public Integer getGroupSort() {
        return groupSort;
    }

    public void setGroupSort(Integer groupSort) {
        this.groupSort = groupSort;
    }

    public Double getExceedPercent() {
        return exceedPercent;
    }

    public void setExceedPercent(Double exceedPercent) {
        this.exceedPercent = exceedPercent;
    }

    public String getQrcodeUrl() {
        return qrcodeUrl;
    }

    public void setQrcodeUrl(String qrcodeUrl) {
        this.qrcodeUrl = qrcodeUrl;
    }

    @Override
    public String toString() {
        return "UserLearningInfoDTO{" +
                "wechatUserId=" + wechatUserId +
                ", nickName='" + nickName + '\'' +
                ", headUrl='" + headUrl + '\'' +
                ", score=" + score +
                ", allLearningTime=" + allLearningTime +
                ", groupSort=" + groupSort +
                ", exceedPercent=" + exceedPercent +
                ", qrcodeUrl='" + qrcodeUrl + '\'' +
                '}';
    }
}
