package com.pcloud.book.group.dto;

import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @ClassName com.pcloud.book.group.dto.WxworkPageFixedDTO
 * @Author zhuyajie
 * @Description 企业微信固定模板参数
 * @Date 2021/12/2 14:42
 **/
@Data
public class WxworkPageFixedDTO implements Serializable {

    @ApiModelProperty("落地页标题")
    private String pageTitle;
    @ApiModelProperty("开始时间")
    private String startTime;
    @ApiModelProperty("结束时间")
    private String endTime;
    @ApiModelProperty("资料图片")
    private List<WxworkPageFileDTO> fileDTOS;
    @ApiModelProperty("限制数量")
    private Integer limitNum;
    @ApiModelProperty("资料logo图")
    private String logoImg;
    @ApiModelProperty("免费领取")
    private String receiveMode;
    @ApiModelProperty("扫码关注")
    private String followMode;
    @ApiModelProperty("扫码添加老师")
    private String bottomTips;
    /**
     * 图片高度
     */
    private Integer height;
}
