package com.pcloud.book.group.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 自有码H5页面通用组件资源
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class ResourcePageFolder extends BaseEntity implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 资源页id
     */
    private Long resourcePageId;

    /**
     * 资源栏目id
     */
    private Long resourcePageColumnId;

    /**
     * 标题
     */
    private String title;

    /**
     * 子标题
     */
    private String subTitle;

    /**
     * 跳转类型 1单资源 2资源列表 3链接
     */
    private Integer jumpType;

    /**
     * 图标
     */
    private String icon;

    /**
     * 链接url
     */
    private String linkUrl;

    /**
     * 排序值
     */
    private Integer seqNum;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    /**
     * 创建人
     */
    private Long createUser;

    private static final long serialVersionUID = 1L;
}