package com.pcloud.book.group.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.Date;

@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class ResourcePageFolderItemVO extends ResourcePageItemVO {
    /**
     * 主键
     */
    private Long id;

    /**
     * 通用组件资源id
     */
    private Long folderId;

    /**
     * 资源页id
     */
    private Long resourcePageId;

    /**
     * 资源栏目id
     */
    private Long resourcePageColumnId;

    /**
     * 资源id
     */
    private Long serveId;

    /**
     * 资源类型
     */
    private String serveType;

    /**
     * 链接url
     */
    private String linkUrl;

    /**
     * 资源类型
     */
    private String typeCode;

    /**
     * 排序值
     */
    private Integer seqNum;

    /**
     * 是否展示
     */
    private Integer isShow;

    /**
     * 二维码引导关注文案
     */
    private String guideContent;

    /**
     * 二维码logo链接
     */
    private String logoUrl;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 创建人
     */
    private Long createUser;

    /**
     * 二维码来源；0：默认公众号；1：自定义
     */
    private Integer qrcodeSource;

    /**
     * 二维码展示方式（1平铺2弹窗）
     */
    private Integer qrcodeShowType;

    /**
     * 二维码公众号id
     */
    private Long accountSettingId;

    /**
     * 自定义大图
     */
    private String selfBigPic;

    /**
     * 自定义小图
     */
    private String selfSmallPic;

    private String selfServeName;

    /**
     * 书刊链接来源（1当当2京东3拼多多）
     */
    private Integer linkFrom;
}
