package com.pcloud.book.personal.biz.impl;

import com.pcloud.book.keywords.entity.RobotSkillDetail;
import com.pcloud.book.personal.biz.PersonalBiz;
import com.pcloud.book.personal.check.PersonalCheck;
import com.pcloud.book.personal.dao.PcloudSkillRecordDao;
import com.pcloud.book.timecontrol.biz.TaskSubscribeBiz;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.string.StringUtilParent;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("personalBiz")
public class PersonalBizImpl implements PersonalBiz {

    @Autowired
    private  PersonalCheck personalCheck;
    @Autowired
    private PcloudSkillRecordDao pcloudSkillRecordDao;

    @Override
    public PageBeanNew<RobotSkillDetail> getSKillRecordPage(Integer skillType, String wxUserId, Integer currentPage, Integer numPerPage) {
        personalCheck.checkParam4SkillList(skillType,wxUserId,numPerPage,currentPage);
        PageBeanNew<RobotSkillDetail> robotSkillDetailPageBeanNew = new PageBeanNew<>();
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("skillType",skillType);
        paramMap.put("wxUserId",wxUserId);
        if (1 == skillType){
            robotSkillDetailPageBeanNew = pcloudSkillRecordDao.listPageNew(new PageParam(currentPage,numPerPage),
                    paramMap,"getSKillRecordPage4Task");
        }else if (2 == skillType){
            //共读活动
            robotSkillDetailPageBeanNew = pcloudSkillRecordDao.listPageNew(new PageParam(currentPage,numPerPage),
                    paramMap,"getSKillRecordPage4Activity");
        }else if (3 == skillType){
            // 配套资源
            robotSkillDetailPageBeanNew = pcloudSkillRecordDao.listPageNew(new PageParam(currentPage,numPerPage),
                    paramMap,"getSKillRecordPage4Resource");
        }
        if (null != robotSkillDetailPageBeanNew && !ListUtils.isEmpty(robotSkillDetailPageBeanNew.getRecordList())){
            handIntroduce(robotSkillDetailPageBeanNew.getRecordList());
        }
        return robotSkillDetailPageBeanNew;
    }

    private void handIntroduce(List<RobotSkillDetail> recordList) {
        recordList.stream().forEach(e ->{
            String filterStr = StringUtilParent.replaceHtml(e.getRelSkillIntroduce());
            e.setCutRelSkillIntroduce(filterStr);
                });
    }
}
