package com.pcloud.book.reading.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("共读活动关联群")
public class ReadingGroup extends BaseEntity{

    @ApiModelProperty("群id")
    private String wxGroupId;

    @ApiModelProperty("群名称")
    private String wxGroupName;

    @ApiModelProperty("活动id")
    private Long activityId;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("创建人")
    private Long createUser;



}