package com.pcloud.book.record.facade;

import com.pcloud.book.book.constant.BookConstant;
import com.pcloud.book.record.biz.BookBrowseRecordBiz;
import com.pcloud.book.record.entity.AreaStatistics;
import com.pcloud.book.record.entity.BookDetail;
import com.pcloud.book.record.entity.BookMapStatistics;
import com.pcloud.book.record.entity.MapData;
import com.pcloud.book.record.entity.RegionMap;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.nginx.NginxUtils;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @ClassName com.pcloud.book.record.facade.BookBrowseRecordFacade
 * @Author 吴博
 * @Description 书籍地图facade
 * @Date 2020/6/15 13:48
 * @Version 1.0
 **/
@RestController
@RequestMapping("bookBrowseRecord")
public class BookBrowseRecordFacade {

    @Autowired
    private BookBrowseRecordBiz bookBrowseRecordBiz;
    @Autowired
    private HttpServletRequest httpServletRequest;

    @GetMapping("getBookCount")
    public ResponseDto<List<BookMapStatistics>> getBookCount4Country(@RequestHeader("token") String token,
            @RequestParam(value = "regionCode",required = false) String regionCode) {
        Map<String,Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        if (Objects.equals(BookConstant.countryRegionCode, regionCode)){
            regionCode = null;
        }
        return new ResponseDto<List<BookMapStatistics>>(bookBrowseRecordBiz.getBookCount4Country(regionCode, agentId));
    }

    @GetMapping("getAreaStatistics")
    public ResponseDto<AreaStatistics> getAreaStatistics(@RequestHeader("token") String token,
            @RequestParam(value = "regionCode" ,required = false) String regionCode,
            @RequestParam("areaCode") Integer areaCode) {
        Map<String,Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        if (Objects.equals(BookConstant.countryRegionCode, regionCode)){
            areaCode = BookConstant.countryAreaCode;
            regionCode = null;
        }
        return new ResponseDto<AreaStatistics>(bookBrowseRecordBiz.getAreaStatistics(regionCode, areaCode, agentId));
    }

    @GetMapping("getBookDetail")
    public ResponseDto<PageBeanNew<BookDetail>> getBookDetail(@RequestHeader("token") String token,
            @RequestParam("regionCode") String regionCode,
            @RequestParam("areaCode") Integer areaCode,
            @RequestParam(value = "currentPage") Integer currentPage,
            @RequestParam(value = "numPerPage") Integer numPerPage,
            @RequestParam(value = "bookName", required = false) String bookName,
            @RequestParam(value = "agentId", required = false) Long agentId,
            @RequestParam(value = "bookClassifyId", required = false) Long bookClassifyId) {
        SessionUtil.getToken4Redis(token);
        if (Objects.equals(BookConstant.countryRegionCode, regionCode)){
            areaCode = BookConstant.countryAreaCode;
            regionCode = null;
        }
        return new ResponseDto<PageBeanNew<BookDetail>>(bookBrowseRecordBiz.getBookDetail(regionCode, areaCode, new PageParam(currentPage,
                numPerPage), bookName, agentId, bookClassifyId));
    }


    @GetMapping("addJsonData")
    public ResponseDto<?> addJsonData(@RequestHeader("token") String token){
        SessionUtil.getToken4Redis(token);
        bookBrowseRecordBiz.addJsonData();
        return  new ResponseDto<>();
    }


    @GetMapping("getJsonData")
    public ResponseDto<PageBeanNew<MapData>> getJsonData(@RequestHeader("token") String token,
            @RequestParam(value = "regionCode", required = false) String regionCode,
            @RequestParam(value = "currentPage") Integer currentPage,
            @RequestParam(value = "numPerPage") Integer numPerPage){
        SessionUtil.getToken4Redis(token);
        PageBeanNew<MapData> mapDataPageBeanNew = bookBrowseRecordBiz.getJsonData(regionCode, currentPage, numPerPage);
        return  new ResponseDto<>(mapDataPageBeanNew);
    }

    @ApiOperation(value = "根据期刊社首字母分组", httpMethod = "GET")
    @RequestMapping(value = "getCitysByPY", method = RequestMethod.GET)
    ResponseDto<Map<String,List<RegionMap>>> getCitysByPY(@RequestHeader("token") String token,
            @RequestParam(value = "keyword", required = false) String keyword) throws BizException, PermissionException {
         SessionUtil.getToken4Redis(token);
        Map<String,List<RegionMap>>  map= bookBrowseRecordBiz.getCitysByPY(keyword);
        return   new ResponseDto<>(map);
    }

    @ApiOperation(value = "处理旧的书刊读者数据", httpMethod = "GET")
    @RequestMapping(value = "handleOldData", method = RequestMethod.GET)
    ResponseDto<?> handleOldData(@RequestHeader("token") String token) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        bookBrowseRecordBiz.handleOldData();
        return new ResponseDto<>();
    }

    @ApiOperation(value = "根据用户IP获取用户信息", httpMethod = "GET")
    @GetMapping("/getCustomerLocation4Ip")
    ResponseDto<?> getCustomerLocation4Ip() {
        return new ResponseDto<>(bookBrowseRecordBiz.getCityByIP(NginxUtils.getClientIp(httpServletRequest)));
    }
}