package com.pcloud.book.rightsSetting.biz;

import com.pcloud.book.rightsSetting.entity.RightsSettingBanner;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;

/**
 * 权益banner(RightsSettingBanner)表服务接口
 *
 * @author makejava
 * @since 2021-03-17 14:15:25
 */
public interface RightsSettingBannerBiz {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    RightsSettingBanner getById(Long id);

    /**
     * 分页查询
     */
    PageBeanNew getList(Integer currentPage, Integer numPerPage);

    /**
     * 新增数据
     *
     * @param rightsSettingBanner 实例对象
     * @return 主键
     */
    Long insert(RightsSettingBanner rightsSettingBanner);

    /**
     * 修改数据
     *
     * @param rightsSettingBanner 实例对象
     */
    void update(RightsSettingBanner rightsSettingBanner);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    void deleteById(Long id);

    /**
     * 批量新增
     * @param rightsSettingBanners
     */
    void batchInsert(List<RightsSettingBanner> rightsSettingBanners);

    /**
     * 根据权益id删除
     * @param rightsSettingId
     */
    void deleteByRightsSettingId(Long rightsSettingId);
    /**
     * 根据权益id查询
     * @author：zhuyajie
     * @date：2021/4/6 14:45
     *  * @param null
     */
    List<RightsSettingBanner> getByRightsSettingId(Long rightsSettingId);
}