package com.pcloud.common.core.biz;

import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.core.constant.MQQueueConstant;
import com.pcloud.common.core.dto.DynamicDto;
import com.pcloud.common.exceptions.BizException;

/**
 * @描述：
 * 
 * @作者：lucas @创建时间：2017年12月14日,15:58 @版本：1.0
 */
@Component("merchantDynamicQueueBiz")
public class MerchantDynamicQueueBizImpl implements MerchantDynamicQueueBiz {

	@Autowired
	private AmqpTemplate amqpTemplate;

	@Override
	@ParamLog("动态监控QUEUE")
	public void send(DynamicDto dynamicDto) throws BizException {
		amqpTemplate.convertAndSend(MQQueueConstant.MERCHANT_DYNAMIC, dynamicDto);
	}

}
