package com.pcloud.common.core.constant;

/**
 * Description 作品类型常量类
 * @author PENG
 * @date 2018/4/26
 */
public class ProductTypeConstant {

    /**
     * 普通实体商品
     */
    public static final String COMMON = "COMMON";

    /**
     * 音频
     */
    public static final String AUDIO = "AUDIO";

    /**
     * 视频
     */
    public static final String VIDEO = "VIDEO";

    /**
     * PDF
     */
    public static final String PDF = "PDF";

    /**
     * 相册
     */
    public static final String ALBUM = "ALBUM";

    /**
     * 问答
     */
    public static final String QA = "QA";

    /**
     * 问答资讯
     */
    public static final String QANEWS = "QANEWS";

    /**
     * 书籍
     */
    public static final String BOOK = "BOOK";

    /**
     * 电子书
     */
    public static final String EBOOK = "EBOOK";

    /**
     * 报名
     */
    public static final String MATCH = "MATCH";

    /**
     * 序列号
     */
    public static final String NUMBER = "NUMBER";

    /**
     * 会员
     */
    public static final String MEMBER = "MEMBER";

    /**
     * 题库
     */
    public static final String PRETEST = "PRETEST";

    /**
     * 普通虚拟商品
     */
    public static final String VIRTUAL = "VIRTUAL";

    /**
     * 看一看商品
     */
    public static final String LOOK = "LOOK";

    /**
     * 直播商品
     */
    public static final String LIVE = "LIVE";

    /**
     * 专家审稿
     */
    public static final String REVIEW = "REVIEW";

    /**
     * 工具商品
     */
    public static final String TOOL = "TOOL";

    /**
     * 一对一辅导
     */
    public static final String TUTOR = "TUTOR";

    /**
     * 圈子商品
     */
    public static final String GROUP = "GROUP";

    /**
     * 标准分
     */
    public static final String ZSCORE = "ZSCORE";

    /**
     * 服务商品
     */
    public static final String QS = "QS";

    /**
     * 听力原文资源
     */
    public static final String LISTEN = "LISTEN";

    /**
     * 多格式资源
     */
    public static final String FORMAT = "FORMAT";

    /**
     * 背单词商品
     */
    public static final String WORD = "WORD";

    /**
     * 文章资源
     */
    public static final String ARTICLE = "ARTICLE";

    /**
     * 第三方服务
     */
    public static final String THIRDPARTY = "THIRDPARTY";

    /**
     * 投票
     */
    public static final String VOTE = "VOTE";

    /**
     * 打卡
     */
    public static final String CLOCK = "CLOCK";

    /**
     * 测试
     */
    public static final String TEST = "TEST";

    /**
     * 直播课表
     */
    public static final String SCHEDULE = "SCHEDULE";

    /**
     * 音频
     */
    public static final String AUDIOAPP = "AUDIOAPP";

    /**
     * 答案
     */
    public static final String ANSWER = "ANSWER";

    /**
     * 教育表格
     */
    public static final String EF = "EF";

    /**
     * 绘本配乐库
     */
    public static final String PBMUSIC = "PBMUSIC";

    /**
     * 一对一辅导
     */
    public static final String TUTORIAL = "TUTORIAL";

    /**
     * 视频课表
     */
    public static final String VIDEO_SCHEDULE = "VIDEO_SCHEDULE";

    /**
     * 视频课表
     */
    public static final String VIDEO_COURSE = "VIDEO_COURSE";

    /**
     * 题库
     */
    public static final String PRETESTAPP = "PRETESTAPP";

    /**
     * 音频
     */
    public static final String AUDIO_RESOURCE = "AUDIO_RESOURCE";

    /**
     * 问答
     */
    public static final String QA_APP = "QA_APP";

    /**
     * 电子书
     */
    public static final String EBOOK_APP = "EBOOK_APP";

    /**
     * 亲子伴读魔法箱
     */
    public static final String AUDIO_MAGIC = "AUDIO_MAGIC";

    /**
     * 音频课
     */
    public static final String AUDIO_SCHEDULE = "AUDIO_SCHEDULE";

    /**
     * 音频课程
     */
    public static final String AUDIO_COURSE = "AUDIO_COURSE";

    /**
     * 导学号
     */
    public static final String DAOXUEHAO = "DAOXUEHAO";

    /**
     * 教辅资料包
     */
    public static final String TEACH_RESOURCE_APP = "TEACH_RESOURCE_APP";

    /**
     * 课件
     */
    public static final String COURSE_WARE = "COURSE_WARE";

    /**
     * 试卷
     */
    public static final String TEST_PAPER_APP = "TEST_PAPER_APP";

    /**
     * 配套听力
     */
    public static final String MATCH_LISTEN = "MATCH_LISTEN";

    /**
     * 生词听写
     */
    public static final String WORD_DICTATION = "WORD_DICTATION";

    /**
     * 笔顺动图
     */
    public static final String STROKE_ORDER_APP = "STROKE_ORDER_APP";

    /**
     * 高清大图
     */
    public static final String IMAGE_APP = "IMAGE_APP";

    /**
     * 会员应用
     */
    public static final String MEMBER_APP = "MEMBER_APP";

    /**
     * 绘本故事
     */
    public static final String PBSTORY = "PBSTORY";

    /**
     * 课文诵读
     */
    public static final String ARTICLE_READING = "ARTICLE_READING";

    /**
     * 英语随身听
     */
    public static final String ENGLISH_WALKMAN = "ENGLISH_WALKMAN";

    /**
     * 口语评测Oral evaluation
     */
    public static final String ORAL_EVALUATION = "ORAL_EVALUATION";

    /**
     * 微信学习群
     */
    public static final String BOOK_GROUP = "BOOK_GROUP";

    /**
     * 延伸阅读
     */
    public static final String PDF_APP = "PDF_APP";

    /**
     * 背单词
     */
    public static final String WORD_APP = "WORD_APP";

    /**
     * 签到打卡
     */
    public static final String ATTENDANCE_TASK = "ATTENDANCE_TASK";

    /**
     * 资源外链
     */
    public static final String LINK = "LINK";

    /**
     * 错题本
     */
    public static final String SUBJECTNOTE = "SUBJECTNOTE";

    /**
     * 错题本
     */
    public static final String SUBJECTNOTE_APP = "SUBJECTNOTE_APP";

    /**
     * 报名应用商品
     */
    public static final String BM = "BM";

    /**
     * 点读书
     */
    public static final String BOOK_CLICK_APP = "BOOK_CLICK_APP";

    /**
     *抽奖
     */
    public static final String DRAW_APP = "DRAW_APP";

    /**
     *冷知识
     */
    public static final String COLD_KNOWLEDGE = "COLD_KNOWLEDGE";


    /**
     * 热门作品类型
     */
    public static final String[] HOT_PRODUCT_TYPE = {QA, PDF, VIDEO, PRETEST};

    /**
     * 资源型作品（免费即可体验）
     */
    public static final String[] RESOURCE_PRODUCT = {AUDIO, VIDEO, PDF, EBOOK, ALBUM, PRETEST, QANEWS,
            FORMAT, WORD, ARTICLE, LISTEN, SCHEDULE, PBMUSIC, TUTORIAL, VIDEO_SCHEDULE, AUDIO_SCHEDULE, LINK, AUDIOAPP, SUBJECTNOTE};

    /**
     * 参与促销激励作品
     */
    public static final String[] PROMOTION_PRODUCT = {AUDIO, VIDEO, PDF, EBOOK, ALBUM, PRETEST, QANEWS,
            FORMAT, WORD, ARTICLE, LISTEN, PBMUSIC, TUTORIAL, COMMON, QA, BOOK, MATCH, NUMBER, REVIEW, TOOL, QS};

    /**
     * 服务型作品（需要特殊操作方可完成使用）
     */
    public static final String[] SERVICE_PRODUCT = {COMMON, QA, BOOK, MATCH, NUMBER, MEMBER, REVIEW, TOOL, QS, THIRDPARTY};

    /**
     * 应用型作品（伴随应用使用）
     */
    public static final String[] APP_PRODUCT = {LOOK, LIVE, TUTOR, GROUP, ZSCORE, VOTE, CLOCK, TEST, AUDIOAPP, ANSWER,
            EF, VIDEO_COURSE, PRETESTAPP, AUDIO_RESOURCE, QA_APP, EBOOK_APP, AUDIO_MAGIC, TEACH_RESOURCE_APP,
            COURSE_WARE, TEST_PAPER_APP, MATCH_LISTEN, WORD_DICTATION, STROKE_ORDER_APP, IMAGE_APP, MEMBER_APP,
            ARTICLE_READING, ENGLISH_WALKMAN, ORAL_EVALUATION, PBSTORY, PDF_APP, WORD_APP, SUBJECTNOTE_APP, BM, BOOK_CLICK_APP};

    /**
     * 数据平台埋点型作品
     */
    public static final String[] TRACK_PRODUCT = {COMMON, AUDIO, VIDEO, PDF, EBOOK, BOOK, MATCH, ALBUM, NUMBER, MEMBER,
            PRETEST, QANEWS, REVIEW, TOOL, QS, FORMAT, WORD, ARTICLE};

    /**
     * 作品下资源来源于content中心的作品
     */
    public static final String[] RESOURCE_CONTENT_PRODUCT = {AUDIO, VIDEO, BOOK, LISTEN, PDF, ALBUM, FORMAT, EBOOK};

    /**
     * 自建码支持的作品类型
     */
    public static final String[] IS_ALI_TYPE_PRODUCT = {AUDIO, VIDEO, PDF, SCHEDULE, VIDEO_SCHEDULE, AUDIO_SCHEDULE,
            LINK, SUBJECTNOTE, ARTICLE, EBOOK, ALBUM, NUMBER, PRETEST, LISTEN, FORMAT, WORD, ARTICLE, PBMUSIC};

    /**
     * 作者端作品类型
     */
    public static final String[] MERCHANT_PRODUCT = {ALBUM, ARTICLE, ATTENDANCE_TASK, AUDIO, AUDIO_COURSE, AUDIO_SCHEDULE,
            BOOK, COMMON, DAOXUEHAO, EBOOK, FORMAT, LINK, LISTEN, MATCH, MEMBER, NUMBER, PBMUSIC, PDF, PRETEST, QA,
            QANEWS, QS, REVIEW, SCHEDULE, SUBJECTNOTE, THIRDPARTY, TOOL, TUTORIAL, VIDEO, VIDEO_SCHEDULE, VIRTUAL, WORD};

    /**
     * 作者端收益需要展示的作品类型
     */
    public static final String[] MERCHANT_INCOME_SHOW_PRODUCT = {COMMON, AUDIO, VIDEO, PDF, QA, EBOOK, BOOK, MATCH, ALBUM,
            NUMBER, MEMBER, PRETEST, LIVE, REVIEW, TOOL, QS, LISTEN, FORMAT, WORD, ARTICLE, THIRDPARTY, SCHEDULE, PBMUSIC,
            TUTORIAL, VIDEO_SCHEDULE, VIDEO_COURSE, AUDIO_SCHEDULE, AUDIO_COURSE, DAOXUEHAO, ATTENDANCE_TASK, LINK, SUBJECTNOTE};
}
