package com.pcloud.common.core.rule;

import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ConfigurationBasedServerList;

import org.springframework.cloud.netflix.ribbon.RibbonClients;

import lombok.extern.slf4j.Slf4j;

/**
 * 自定义灰度策略
 */
@Slf4j
@RibbonClients(defaultConfiguration = GrayRibbonConfig.class)
public class RibbonClientConfig {

    public static class BazServiceList extends ConfigurationBasedServerList {
        public BazServiceList(IClientConfig config) {
            super.initWithNiwsConfig(config);
        }
    }
}
