package com.pcloud.book.adnews.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiParam;
import lombok.Data;

import java.util.List;

/**
 * @author zhengyongqiang
 * @date 2019/8/12 11:33
 */
@Data
@ApiModel("查询素材列表")
public class AdNewsListParam {

    @ApiModelProperty("当前人")
    private Long partyId;

    @ApiModelProperty ("标题")
    private String title;

    @ApiModelProperty("开始时间")
    private String beginTime;

    @ApiModelProperty("结束时间")
    private String endTime;

    @ApiModelProperty ("公众号id")
    private List<Long> adNewsWechatIds;

    @ApiModelProperty(value = "公众号来源；", dataType = "com.pcloud.book.adnews.enums.AdContentFromEnum")
    private Integer contentFrom;

    @ApiModelProperty("已被禁用；0:没禁用; 1:已禁用;")
    private Integer hasBan;

    @ApiModelProperty("使用状态；0:未使用; 1:已使用;")
    private Integer hasUsed;

    @ApiModelProperty("当前页")
    private Integer currentPage;

    @ApiModelProperty("每页展示条数")
    private Integer numPerPage;
}
