package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.dao.AppletNewsDao;
import com.pcloud.book.applet.dto.AppletNewsDTO;
import com.pcloud.book.applet.entity.AppletNews;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 小程序资讯
 */
@Component
public class AppletNewsDaoImpl extends BaseDaoImpl<AppletNews> implements AppletNewsDao {

    @Override
    public List<AppletNews> getByNewsClassifyId(Long newsClassifyId) {
        return getSessionTemplate().selectList(getStatement("getByNewsClassifyId"), newsClassifyId);
    }

    @Override
    public void updateNewsShowState(AppletNews appletNews) {
        getSessionTemplate().update(getStatement("updateNewsShowState"),appletNews);
    }

    @Override
    public List<AppletNewsDTO> getByNewsByTempletLabel(Long firstClassify, Long secondClassify, Long gradeLabelId, Long subjectLabelId, String rightsType) {
        Map<String,Object> map = new HashMap<>();
        map.put("firstClassify", firstClassify);
        map.put("secondClassify", secondClassify);
        map.put("gradeLabelId",gradeLabelId);
        map.put("subjectLabelId", subjectLabelId);
        map.put("rightsType",rightsType);
        return getSessionTemplate().selectList(getStatement("getByNewsByTempletLabel"),map);

    }

    @Override
    public List<AppletNews> getByTempletAndClassify(Long firstClassify, Long secondClassify, Long gradeLabelId, Long subjectLabelId, Long rightsClassifyId, Integer top) {
        Map<String,Object> map = new HashMap<>();
        map.put("firstClassify", firstClassify);
        map.put("secondClassify", secondClassify);
        map.put("gradeLabelId",gradeLabelId);
        map.put("subjectLabelId", subjectLabelId);
        map.put("rightsClassifyId",rightsClassifyId);
        map.put("top", top);
        return getSessionTemplate().selectList(getStatement("getByTempletAndClassify"),map);
    }

    @Override
    public void insertSource(String source) {
        getSessionTemplate().insert(getStatement("insertSource"),source);
    }

    @Override
    public List<String> getNewsSourceList() {
        return getSessionTemplate().selectList(getStatement("getNewsSourceList"));
    }

    @Override
    public Integer getAppletNewsSourceCount(String source) {
        return getSessionTemplate().selectOne(getStatement("getAppletNewsSourceCount"),source);
    }

    @Override
    public void deleteSource(String source) {
        getSessionTemplate().delete(getStatement("deleteSource"),source);
    }

    @Override
    public Boolean newsSourceExist(String source) {
        return getSessionTemplate().selectOne(getStatement("newsSourceExist"),source);
    }
}
