package com.pcloud.book.book.biz;

import com.pcloud.book.book.entity.HotBook;
import com.pcloud.book.book.entity.SearchRecord;
import com.pcloud.book.book.vo.BookSearchTopVO;
import com.pcloud.book.book.vo.SearchBookVO;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;

public interface SearchBiz {
    void createHotBook(HotBook hotBook);

    void deleteHotBook(Long id);

    PageBeanNew<HotBook> getHotBookList(Integer currentPage,Integer numPerPage);

    void updateHotBookSeqNum(HotBook hotBook);

    void createSearchRecord4H5(SearchRecord searchRecord);

    PageBeanNew<SearchBookVO> getSearchList(String content, Integer currentPage, Integer numPerPage);

    PageBeanNew<SearchRecord> getSearchRecordList(String content, Long bookId, Long agentId, Integer currentPage, Integer numPerPage);

    PageBeanNew<SearchRecord> getUserSearchList4H5(String wxId, Long wechatUserId, Integer currentPage, Integer numPerPage);

    void deleteUserSearchList4H5(String wxId, Long wechatUserId);

    void exportSearchList(String systemCode, Long partyId, String content);

    void exportSearchRecordList(String systemCode, Long partyId, String content, Long bookId, Long agentId);

    List<String> getBookSearchUserList4H5(Long bookId);

    List<BookSearchTopVO> getBookSearchTop(Integer top);

    void createSearchRecordDis(SearchRecord searchRecord);
}
