package com.pcloud.book.consumer.wechat;


import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.facade.wechat.service.QrcodeService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Slf4j
@Component("wechatConsr")
public class WechatConsr {

    @Autowired
    private QrcodeService qrcodeService;

    @ParamLog("生成小程序二维码")
    public String create4MiniApp(Long officialAccountId, String scene, Integer width, String page){
        String url="";
        try {
           url = ResponseHandleUtil.parseResponse(qrcodeService.create4MiniApp(officialAccountId, scene, width, page),String.class);

        }catch (Exception e){
            log.error("qrcodeService.create4MiniApp调用失败"+e.getMessage(),e);
        }
        return url;
    }
}
