package com.pcloud.book.copyright.entity;

import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * @author lily
 * @date 2018/12/4 19:21
 */
@ApiModel
public class BookExportRecord extends BaseEntity {

    private Long id;

    @ApiModelProperty("图书标识")
    private Long bookId;

    @ApiModelProperty("运营标识")
    private Long channelId;

    @ApiModelProperty("编辑标识")
    private Long adviserId;

    @ApiModelProperty("批次号")
    private String batchNum;

    @ApiModelProperty("下载地址")
    private String downloadUrl;

    @ApiModelProperty("创建人")
    private Long createdUser;

    @ApiModelProperty("创建时间")
    private Date createdDate;

    @ApiModelProperty("最后修改人")
    private Long lastModifiedUser;

    @ApiModelProperty("最后修改时间")
    private Date lastModifiedDate;

    @ApiModelProperty("导出状态")
    private Integer exportStatus;
    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Long getAdviserId() {
        return adviserId;
    }

    public void setAdviserId(Long adviserId) {
        this.adviserId = adviserId;
    }

    public String getBatchNum() {
        return batchNum;
    }

    public void setBatchNum(String batchNum) {
        this.batchNum = batchNum;
    }

    public String getDownloadUrl() {
        return downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public Long getCreatedUser() {
        return createdUser;
    }

    public void setCreatedUser(Long createdUser) {
        this.createdUser = createdUser;
    }

    public Date getCreatedDate() {
        return createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Long getLastModifiedUser() {
        return lastModifiedUser;
    }

    public void setLastModifiedUser(Long lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    public Date getLastModifiedDate() {
        return lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public Integer getExportStatus() {
        return exportStatus;
    }

    public void setExportStatus(Integer exportStatus) {
        this.exportStatus = exportStatus;
    }

    @Override
    public String toString() {
        return "BookExportRecord{" +
                "id=" + id +
                ", bookId=" + bookId +
                ", channelId=" + channelId +
                ", adviserId=" + adviserId +
                ", batchNum='" + batchNum + '\'' +
                ", downloadUrl='" + downloadUrl + '\'' +
                ", createdUser=" + createdUser +
                ", createdDate=" + createdDate +
                ", lastModifiedUser=" + lastModifiedUser +
                ", lastModifiedDate=" + lastModifiedDate +
                ", exportStatus=" + exportStatus +
                '}';
    }
}
