package com.pcloud.book.giftcoupon.service.impl;

import com.pcloud.book.giftcoupon.biz.GiftCouponPackageBiz;
import com.pcloud.book.giftcoupon.entity.GiftCouponPackage;
import com.pcloud.book.giftcoupon.service.GiftCouponService;
import com.pcloud.book.giftcoupon.vo.GiftCouponVo;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ResponseHandleUtil;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;


@RestController("giftCouponService")
@RequestMapping("giftCouponService")
public class GiftCouponServiceImpl implements GiftCouponService {

    @Autowired
    private GiftCouponPackageBiz giftCouponPackageBiz;

    @Override
    @RequestMapping(value = "/getCouponBaseInfo", method = RequestMethod.GET)
    public ResponseEntity<ResponseDto<GiftCouponVo>> getCouponBaseInfo(@RequestParam("couponId") Long couponId) throws BizException {
        GiftCouponPackage giftPackage = giftCouponPackageBiz.getGiftPackage(couponId);
        GiftCouponVo giftCouponVo=new GiftCouponVo();
        BeanUtils.copyProperties(giftPackage,giftCouponVo);
        return ResponseHandleUtil.toResponse(giftCouponVo);
    }
}
