package com.pcloud.book.reading.dao.impl;

import com.pcloud.book.reading.dao.ReadingUserDao;
import com.pcloud.book.reading.dto.ActivityUserBookDTO;
import com.pcloud.book.reading.dto.ActivityUserCountDTO;
import com.pcloud.book.reading.entity.ReadingUser;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @描述：共读活动邀请用户
 * @作者：zhuyajie
 * @创建时间：17:31 2020/1/14
 * @版本：1.0
 */
@Component("readingUserDao")
public class ReadingUserDaoImpl extends BaseDaoImpl<ReadingUser> implements ReadingUserDao {

    @Override
    public List<ReadingUser> getByActivityId(Long activityId, Integer joinState) {
        Map<String,Object> map = new HashMap<>();
        map.put("activityId",activityId);
        map.put("joinState",joinState);
        return getSessionTemplate().selectList(getStatement("getByActivityId"),map);
    }

    @Override
    public void updateJoinState(Integer joinState, String wxUserId, String activityId) {
        Map<String, Object> map = new HashMap<>();
        map.put("activityId", activityId);
        map.put("wxUserId", wxUserId);
        map.put("joinState", joinState);
        getSessionTemplate().update(getStatement("updateJoinState"), map);
    }

    @Override
    public List<ActivityUserCountDTO> getUserCountsByActivityIds(List<Long> activityIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("activityIds", activityIds);
        return getSessionTemplate().selectList(getStatement("getUserCountsByActivityIds"), map);
    }

    @Override
    public List<String> getWxUserIdByActivityIds(List<Long> activityIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("activityIds", activityIds);
        return getSessionTemplate().selectList(getStatement("getWxUserIdByActivityIds"), map);
    }

    @Override
    public List<ActivityUserBookDTO> getBooksByActivityIds(List<Long> activityIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("activityIds", activityIds);
        return getSessionTemplate().selectList(getStatement("getBooksByActivityIds"), map);
    }
}
