package com.pcloud.book.timecontrol.mapper;


import com.pcloud.book.timecontrol.entity.TimeControlPrizeItem;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;

@Component("taskPrizeItemMapper")
public interface TaskPrizeItemMapper {
    int insert(TimeControlPrizeItem model);

    TimeControlPrizeItem selectByPrimaryKey(Integer id);

    /**
     * 根据prizeId和类型查询奖励详情
     * @param prizeId
     * @param prizeType
     * @return
     */
    TimeControlPrizeItem getByPrizeId(@Param("prizeId") Integer prizeId, @Param("prizeType") Integer prizeType);

    /**
     * 批量新增奖励详情
     * @param prizeItemList
     */
    void batchInsert(@Param("prizeItemList") List<TimeControlPrizeItem> prizeItemList);

    /**
     * 根据prizeId删除奖励
     * @param prizeId
     */
    void deleteByPrizeId(Integer prizeId);

    /**
     * 根据奖励id获取奖励的item列表
     * @param prizeId
     * @return
     */
    List<TimeControlPrizeItem> listByPrizeId(Integer prizeId);

    /**
     * 根据taskItemId删除奖励
     * @param taskItemId
     * @param deleteTypes
     */
    void deleteByTaskItemId(@Param("taskItemId") Integer taskItemId, @Param("deleteTypes") List<Integer> deleteTypes);
}