package com.pcloud.book.util.common;

import com.google.common.util.concurrent.ThreadFactoryBuilder;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolUtils {

    /**
     * 异步导出线程池
     */
    public static final ExecutorService EXPORT_THREAD_POOL = new ThreadPoolExecutor(8, 8, 0L, TimeUnit.SECONDS,
            new LinkedBlockingQueue<>(), new ThreadFactoryBuilder().setNameFormat("export-pool-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());

    /**
     * 异步发送线程池
     */
    public static final ThreadPoolExecutor SEND_MESSAGE_THREAD_POOL = new ThreadPoolExecutor(8, 8, 0, TimeUnit.SECONDS,
            new LinkedBlockingQueue<>(), new ThreadFactoryBuilder().setNameFormat("send-message-pool-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());

    /**
     * 异步导出线程池
     */
    public static final ExecutorService OTHER_THREAD_POOL = new ThreadPoolExecutor(8, 8, 0L, TimeUnit.SECONDS,
            new LinkedBlockingQueue<>(), new ThreadFactoryBuilder().setNameFormat("other-pool-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());

    /**
     * 入群邀请链接发送之前发送冒泡消息线程池
     */
    public static final ExecutorService SEND_MAOPAO_THREAD_POOL = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS,
            new LinkedBlockingQueue<>(), new ThreadFactoryBuilder().setNameFormat("other-pool-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());

    /**
     * 小程序小睿蹭光退出线程池
     */
    public static final ExecutorService SIGN_OUT_THREAD_POOL = new ThreadPoolExecutor(5, 5, 0L, TimeUnit.SECONDS,
            new LinkedBlockingQueue<>(), new ThreadFactoryBuilder().setNameFormat("sign-out-pool-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());

    /**
     * 其他线程池
     */
    public static final ExecutorService OTHER_POOL = new ThreadPoolExecutor(8, 8, 0L, TimeUnit.SECONDS,
            new LinkedBlockingQueue<>(), new ThreadFactoryBuilder().setNameFormat("other-pool-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());

    /**
     * 其他线程池
     */
    public static final ExecutorService SEND_NOTIFY_POOL = new ThreadPoolExecutor(8, 8, 0L, TimeUnit.SECONDS,
            new LinkedBlockingQueue<>(), new ThreadFactoryBuilder().setNameFormat("send-notify-pool-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());
}
