package com.pcloud.common.core.biz;

import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.core.constant.MQQueueConstant;
import com.pcloud.common.core.dto.UserActionMessageDto;
import com.pcloud.common.exceptions.BizException;

/**
 * @描述： 发送模板消息队列实现类 @作者： shuyh @创建时间： 2017年5月23日 @版本：1.0
 */
@Service("userActionQueueBiz")
public class UserActionQueueBizImpl implements UserActionQueueBiz {

	@Autowired
	private AmqpTemplate amqpTemplate;

	/**
	 * 用户行为QUEUE
	 */
	@Override
	@ParamLog("用户行为QUEUE")
	public void sendMessageQueue(UserActionMessageDto userActionMessageDto) throws BizException {
		amqpTemplate.convertAndSend(MQQueueConstant.USER_ACTION, userActionMessageDto);
	}

}
