package com.pcloud.common.core.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiParam;

import java.io.Serializable;

@ApiModel("exapi消息内容dto")
public class ExapiMessageContentDto implements Serializable{
    private static final long serialVersionUID = -8719997620781196408L;

    @ApiModelProperty("用户id，即wechatuserid")
    Long customerId;
    @ApiModelProperty("用户头像")
    String headUrl;
    @ApiModelProperty("用户昵称")
    String nickName;
    @ApiModelProperty("用户性别,0代表女，1代表男")
    Integer sex;
    @ApiModelProperty("用户所在省份")
    String province;
    @ApiModelProperty("用户所在市")
    String city;
    @ApiModelProperty("行为时间")
    String actionTime;
    @ApiModelProperty("商品所在出版社名称")
    String agentName;
    @ApiModelProperty("商品名称")
    String productName;
    @ApiModelProperty("扫码名称")
    String sceneName;
    @ApiModelProperty("书籍名称")
    String bookName;
    @ApiModelProperty("公众号名称名称")
    String officialAccountName;

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getHeadUrl() {
        return headUrl;
    }

    public void setHeadUrl(String headUrl) {
        this.headUrl = headUrl;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getActionTime() {
        return actionTime;
    }

    public void setActionTime(String actionTime) {
        this.actionTime = actionTime;
    }

    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getSceneName() {
        return sceneName;
    }

    public void setSceneName(String sceneName) {
        this.sceneName = sceneName;
    }

    public String getBookName() {
        return bookName;
    }

    public void setBookName(String bookName) {
        this.bookName = bookName;
    }

    public String getOfficialAccountName() {
        return officialAccountName;
    }

    public void setOfficialAccountName(String officialAccountName) {
        this.officialAccountName = officialAccountName;
    }

    @Override
    public String toString() {
        return "ExapiMessageContentDto{" +
                "customerId=" + customerId +
                ", headUrl='" + headUrl + '\'' +
                ", nickName='" + nickName + '\'' +
                ", sex=" + sex +
                ", province='" + province + '\'' +
                ", city='" + city + '\'' +
                ", actionTime='" + actionTime + '\'' +
                ", agentName='" + agentName + '\'' +
                ", productName='" + productName + '\'' +
                ", sceneName='" + sceneName + '\'' +
                ", bookName='" + bookName + '\'' +
                ", officialAccountName='" + officialAccountName + '\'' +
                '}';
    }
}
