package com.pcloud.book.clock.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * @Author: hzk
 * @Date: 2019/6/2 15:33
 * @Version 1.0
 */
public class BookGroupClockKeywordDTO extends BaseDto {

    private static final long serialVersionUID = -852531178830896628L;

    @ApiModelProperty("bookClockKeywordId")
    private Long bookClockKeywordId;

    @ApiModelProperty("作品/应用ID")
    private Long bookClockInfoId;

    @ApiModelProperty("操作")
    private String operation;

    @ApiModelProperty("关键词")
    private String keyword;

    @ApiModelProperty("关键词引导语")
    private String guide;

    @ApiModelProperty("渠道ID")
    private Long channelId;

    @ApiModelProperty("排序值")
    private Long sequenceNum;

    @ApiModelProperty("创建人")
    private Long createUser;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改人")
    private Long updateUser;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("修改时间")
    private Date updateTime;

    public Long getBookClockKeywordId() {
        return bookClockKeywordId;
    }

    public void setBookClockKeywordId(Long bookClockKeywordId) {
        this.bookClockKeywordId = bookClockKeywordId;
    }

    public Long getBookClockInfoId() {
        return bookClockInfoId;
    }

    public void setBookClockInfoId(Long bookClockInfoId) {
        this.bookClockInfoId = bookClockInfoId;
    }

    public String getOperation() {
        return operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getGuide() {
        return guide;
    }

    public void setGuide(String guide) {
        this.guide = guide;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Long getSequenceNum() {
        return sequenceNum;
    }

    public void setSequenceNum(Long sequenceNum) {
        this.sequenceNum = sequenceNum;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getUpdateUser() {
        return updateUser;
    }

    public void setUpdateUser(Long updateUser) {
        this.updateUser = updateUser;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @Override
    public String toString() {
        return "BookGroupClockKeywordDTO{" +
                "bookClockKeywordId=" + bookClockKeywordId +
                ", bookClockInfoId=" + bookClockInfoId +
                ", operation='" + operation + '\'' +
                ", keyword='" + keyword + '\'' +
                ", guide='" + guide + '\'' +
                ", channelId=" + channelId +
                ", sequenceNum=" + sequenceNum +
                ", createUser=" + createUser +
                ", createTime=" + createTime +
                ", updateUser=" + updateUser +
                ", updateTime=" + updateTime +
                '}';
    }
}
