/**
 * 
 */
package com.pcloud.book.consumer.analysisengine;

import com.pcloud.analysisengine.browse.dto.BrowseCacheRecordDto;
import com.pcloud.analysisengine.browse.dto.GroupBrowseStatisticVO;
import com.pcloud.analysisengine.browse.dto.SBookAnalyzeDto;
import com.pcloud.analysisengine.browse.service.BrowseRecordService;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @描述：分析引擎中间件
 * @作者：songx
 * @创建时间：2017年2月16日,下午2:02:46 @版本：1.0
 */
@Component("browseRecordConsr")
public class BrowseRecordConsr {

	/**
	 * logger
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(BrowseRecordConsr.class);

	@Autowired
	private BrowseRecordService browseRecordService;

	/**
	 * 获取资源文件浏览量
	 */
	public Map<Long, Long> getPvOfAdviserRes(List<Long> resourceFileIds) throws BizException {
		LOGGER.info("[getPvOfAdviserRes] resourceFileIds:{}", resourceFileIds);
		if (ListUtils.isEmpty(resourceFileIds)) {
			return null;
		}
		Map<Long, Long> resultMap = null;
		try {
			resultMap = ResponseHandleUtil.parseMapResponse(browseRecordService.getPvOfAdviserRes(resourceFileIds),
					Long.class, Long.class);
		} catch (BizException e) {
			LOGGER.warn("【分析引擎(消)】获取资源文件浏览量,<getPvOfAdviserRes>:" + e.getMessage(), e);
		} catch (Exception e) {
			LOGGER.error("【分析引擎(消)】获取资源文件浏览量.[getPvOfAdviserRes]:" + e.getMessage(), e);
		}
		return resultMap;
	}

	/**
	 * 图书的：扫描量、读者量
	 * 
	 * @param adviserIds
	 * @param channelIds
	 * @param bookIds
	 * @return
	 */
	public Map<String, BrowseCacheRecordDto> getBookScanAndUv(List<Long> adviserIds, List<Long> channelIds,
			List<Long> bookIds) {
		LOGGER.info("【分析引擎(消)】图书的：扫描量、读者量,<START>.[adviserIds]=" + adviserIds + "channelIds=" + channelIds + "bookIds="
				+ bookIds);
		Map<String, List<Long>> bookAdviserChannelIdMap = new HashMap<>();
		bookAdviserChannelIdMap.put("adviserIds", adviserIds);
		bookAdviserChannelIdMap.put("channelIds", channelIds);
		bookAdviserChannelIdMap.put("bookIds", bookIds);
		Map<String, BrowseCacheRecordDto> resultMap = null;
		try {
			resultMap = ResponseHandleUtil.parseMapResponse(
					browseRecordService.getBookScanAndUv(bookAdviserChannelIdMap), String.class,
					BrowseCacheRecordDto.class);
		} catch (BizException e) {
			LOGGER.warn("【分析引擎(消)】图书的：扫描量、读者量.[getBookScanAndUv]:" + e.getMessage(), e);
		} catch (Exception e) {
			LOGGER.error("【分析引擎(消)】图书的：扫描量、读者量.[getBookScanAndUv]:" + e.getMessage(), e);
		}
		return resultMap;
	}

	/**
	 * 图书的：扫描量、读者量、浏览量
	 * 
	 * @param adviserIds
	 * @param channelIds
	 * @param bookIds
	 * @return
	 */
	public Map<String, BrowseCacheRecordDto> getBookSvUvPv(List<Long> adviserIds, List<Long> channelIds,
			List<Long> bookIds) {
		LOGGER.info("【分析引擎(消)】图书的：扫描量、读者量、浏览量,<START>.[adviserIds]=" + adviserIds + "channelIds=" + channelIds
				+ "bookIds=" + bookIds);
		Map<String, List<Long>> bookAdviserChannelIdMap = new HashMap<>();
		bookAdviserChannelIdMap.put("adviserIds", adviserIds);
		bookAdviserChannelIdMap.put("channelIds", channelIds);
		bookAdviserChannelIdMap.put("bookIds", bookIds);
		Map<String, BrowseCacheRecordDto> resultMap = null;
		try {
			resultMap = ResponseHandleUtil.parseMapResponse(browseRecordService.getBookSvUvPv(bookAdviserChannelIdMap),
					String.class, BrowseCacheRecordDto.class);
		} catch (BizException e) {
			LOGGER.warn("【分析引擎(消)】图书的：扫描量、读者量、浏览量.[getBookScanAndUv]:" + e.getMessage(), e);
		} catch (Exception e) {
			LOGGER.error("【分析引擎(消)】图书的：扫描量、读者量、浏览量.[getBookScanAndUv]:" + e.getMessage(), e);
		}
		return resultMap;
	}

	@ParamLog(description = "设置书刊分析读者量、浏览量")
	public Map<String, SBookAnalyzeDto> getMonthBookPvUvSuScvr(List<SBookAnalyzeDto> sBookAnalyzeDtos,String monthDate){
		Map<String, SBookAnalyzeDto> sBookAnalyzeDtoMap = null;

		try {
			sBookAnalyzeDtoMap = ResponseHandleUtil.parseMapResponse(browseRecordService.getMonthBookPvUvSuScvr(sBookAnalyzeDtos,monthDate),String.class,SBookAnalyzeDto.class);
		} catch (BizException e) {
			LOGGER.warn("【分析引擎(消)】图书的：读者量、浏览量.[getMonthBookPvUvSuScvr]:" + e.getMessage(), e);
		} catch (Exception e) {
			LOGGER.error("【分析引擎(消)】图书的：读者量、浏览量.[getMonthBookPvUvSuScvr]:" + e.getMessage(), e);
		}
		return sBookAnalyzeDtoMap;
	}

	@ParamLog("获取社群码资源浏览量")
	public Map<Long, GroupBrowseStatisticVO> mapGroupBrowseStatistic(List<Long> bookGroupIds, String monthDate) {
		Map<Long, GroupBrowseStatisticVO> map = null;
		try {
			map = ResponseHandleUtil.parseMapResponse(browseRecordService.mapGroupBrowseStatistic(bookGroupIds, monthDate), Long.class, GroupBrowseStatisticVO.class);
		} catch (Exception e) {
			LOGGER.error("获取社群码资源浏览量失败" + e.getMessage(), e);
		}
		return map;
	}

}
