package com.pcloud.book.weixinclock.dao;

import com.pcloud.book.weixinclock.dto.RankDto;
import com.pcloud.book.weixinclock.entity.WeixinClockMember;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * @author 杨涛
 * @description TODO
 * @date 2019/8/16 9:59
 */
public interface WeixinClockMemberDao extends BaseDao<WeixinClockMember> {

    /**
     * 获取某个群内的打卡排行榜
     * @param wxGroupId
     * @return
     */
    List<RankDto> listWeixinClockRank(String wxGroupId, String wxUserId);

    /**
     * 获取某个群内某用户的信息
     * @param userWxId
     * @return
     */
    WeixinClockMember getByWxUserId(String wechatGroupId, String userWxId);

    /**
     * 更新打卡天数
     * @param userWxId
     * @return
     */
    void updateClockDays(String wechatGroupId, String userWxId, Long wechatUserId);

    /**
     * 获取的打卡排名（微信群）
     * @param wechatGroupId
     * @param userWxId
     * @return
     */
    Integer getMyNewOrder(String wechatGroupId, String userWxId);

    /**
     * 获取某个群内某个用户的信息
     * @param wxGroupId
     * @param wechatUserId
     * @return
     */
    RankDto getClockWechatUserRank(Long wechatUserId, String wxGroupId);

    /**
     * 同步wechatuserId
     * @param wxUserId
     * @param wechatUserId
     * @return
     */
    void updatMemberWechatUserId(String wxUserId, Long wechatUserId);

    /**
     * 获取某个群内某个用户的信息
     * @param wxGroupId
     * @param wxUserId
     * @return
     */
    RankDto getClockWechatUserRankByWxUserId(String wxUserId, String wxGroupId);

    /**
     * 更新打卡成员得分
     * @param weixinClockMemberId
     * @param isCancel
     */
    void updateScore(Long weixinClockMemberId, Integer isCancel);

    /**
     * 旧数据处理：初始化成员分数
     */
    void initScore();

    /**
     * 旧数据处理：打卡分数+点赞分数
     * @param wxUserId
     * @param wxGroupId
     * @param praiseNum
     */
    void addPraiseNum(String wxUserId, String wxGroupId, Integer praiseNum);
}
