package com.pcloud.book.advertising.dao;

import com.pcloud.book.advertising.entity.AdvertisingPlanGroup;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

public interface AdvertisingPlanGroupDao extends BaseDao<AdvertisingPlanGroup> {
    Integer batchInsert(List<AdvertisingPlanGroup> advertisingPlanGroups);

    /**
     * 根据计划id查询
     */
    List<AdvertisingPlanGroup> getListByPlanId(Long planId);

    /**
     * 批量删除
     */
    void deleteByIds(List<Long> ids, Long partyId);

    /**
     * 根据计划id删除
     */
    void deleteByPlanId(Long planId, Long partyId);

    /**
     * 根据计划id集合查询
     */
    List<AdvertisingPlanGroup> getListByPlanIds(List<Long> planIds);
}
