package com.pcloud.book.applet.dao;

import com.pcloud.book.applet.dto.AppletUserBookcaseDTO;
import com.pcloud.book.applet.dto.UserLastBookReDTO;
import com.pcloud.book.applet.entity.AppletUserBookcase;
import com.pcloud.book.applet.entity.AppletUserClickRecord;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * 小程序用户书架
 */
public interface AppletUserBookcaseDao extends BaseDao<AppletUserBookcase> {

    /**
     * 新增用户资源点击记录
     * @param appletUserClickRecord
     */
    void  insertClickRecord(AppletUserClickRecord appletUserClickRecord);

    /**
     * 用户点击的服务id
     * @param wechatUserId
     * @param bookId
     * @param channelId
     * @param adviserId
     * @return
     */
    Integer getUserClickServerCount(Long wechatUserId, Long bookId, Long channelId, Long adviserId, List<Long> serveIds, String fromType);

    /**
     * 最早资源点击日期
     * @param wechatUserId
     * @param bookId
     * @param channelId
     * @param adviserId
     * @return
     */
    String getMinClickTime (Long wechatUserId, Long bookId, Long channelId, Long adviserId, List<Long> serveIds, String fromType);

    /**
     * 删除
     * @param appletUserBookcase
     */
    void deleteByBookIdUserId(AppletUserBookcase appletUserBookcase);

    UserLastBookReDTO getUserLastGroupBookRe(Long wechatUserId);

    UserLastBookReDTO getUserLastRe(Long wechatUserId);

    /**
     * 批量删除
     * @author：zhuyajie
     * @date：2020/5/11 16:06
     *  * @param null
     */
    void deleteByIds(List<Long> ids);

    void updateUserReadType(AppletUserBookcase appletUserBookcase);

    AppletUserBookcase getUserReadType(Long wechatUserId, Long bookId, Long adviserId, Long channelId);
    /**
     * 查书架列表
     * @author：zhuyajie
     * @date：2020/5/15
     *  * @param null
     */
    List<AppletUserBookcase> getListByUserId(Long wechatUserId);

    /**
     * 书架id
     * @author：zhuyajie
     * @date：2020/5/29 13:11
     *  * @param null
     */
    List<Long> getBookcaseIdListByUser(Long wechatUserId);
}
