package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.dao.AppletUserBookcaseDao;
import com.pcloud.book.applet.dto.UserLastBookReDTO;
import com.pcloud.book.applet.entity.AppletUserBookcase;
import com.pcloud.book.applet.entity.AppletUserClickRecord;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 小程序用户书架
 */
@Component
public class AppletUserBookcaseDaoImpl extends BaseDaoImpl<AppletUserBookcase> implements AppletUserBookcaseDao {


    @Override
    public void insertClickRecord(AppletUserClickRecord appletUserClickRecord) {
        getSessionTemplate().insert(getStatement("insertClickRecord"),appletUserClickRecord);
    }

    @Override
    public Integer getUserClickServerCount(Long wechatUserId, Long bookId, Long channelId, Long adviserId,List<Long> serveIds, String fromType) {
        Map<String,Object> map = new HashMap<>();
        map.put("wechatUserId", wechatUserId);
        map.put("bookId", bookId);
        map.put("channelId", channelId);
        map.put("adviserId", adviserId);
        map.put("list",serveIds);
        map.put("fromType", fromType);
        return getSessionTemplate().selectOne(getStatement("getUserClickServerCount"), map);
    }

    @Override
    public String getMinClickTime(Long wechatUserId, Long bookId, Long channelId, Long adviserId,List<Long> serveIds, String fromType) {
        Map<String,Object> map = new HashMap<>();
        map.put("wechatUserId", wechatUserId);
        map.put("bookId", bookId);
        map.put("channelId", channelId);
        map.put("adviserId", adviserId);
        map.put("list",serveIds);
        map.put("fromType", fromType);
        return getSessionTemplate().selectOne(getStatement("getMinClickTime"),map);
    }

    @Override
    public void deleteByBookIdUserId(AppletUserBookcase appletUserBookcase) {
        getSessionTemplate().delete(getStatement("deleteByBookIdUserId"),appletUserBookcase);
    }

    @Override
    public UserLastBookReDTO getUserLastGroupBookRe(Long wechatUserId) {
        return getSessionTemplate().selectOne(getStatement("getUserLastGroupBookRe"),wechatUserId);
    }

    @Override
    public UserLastBookReDTO getUserLastRe(Long wechatUserId) {
        return getSessionTemplate().selectOne(getStatement("getUserLastRe"),wechatUserId);
    }

    @Override
    public void deleteByIds(List<Long> list) {
        getSessionTemplate().delete(getStatement("deleteByIds"), list);
    }

    @Override
    public void updateUserReadType(AppletUserBookcase appletUserBookcase) {
        getSessionTemplate().update(getStatement("updateUserReadType"),appletUserBookcase);
    }

    @Override
    public AppletUserBookcase getUserReadType(Long wechatUserId, Long bookId, Long adviserId, Long channelId) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("wechatUserId",wechatUserId);
        paramMap.put("bookId",bookId);
        paramMap.put("adviserId",adviserId);
        paramMap.put("channelId",channelId);
        return getSessionTemplate().selectOne(getStatement("getUserReadType"),paramMap);
    }

    @Override
    public List<AppletUserBookcase> getListByUserId(Long wechatUserId) {
        return getSessionTemplate().selectList(getStatement("getListByUserId"), wechatUserId);
    }

    @Override
    public List<Long> getBookcaseIdListByUser(Long wechatUserId) {
        return getSessionTemplate().selectList(getStatement("getBookcaseIdListByUser"), wechatUserId);
    }
}
