package com.pcloud.book.mq.delay;

import com.pcloud.common.core.mq.DelayQueueDTO;
import com.pcloud.common.core.mq.MQExchangeConstants;

import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

/**
 * 延时队列消息生产者
 */
@Slf4j
@Component
public class DelayMessageSender {

    @Resource
    private RabbitTemplate rabbitTemplate;

    public void send(DelayQueueDTO dto) {
        this.rabbitTemplate.convertAndSend(MQExchangeConstants.BOOK_DELAYED_EXCHANGE, MQExchangeConstants.BOOK_DELAY_ROUTING_KEY, dto, message -> {
            message.getMessageProperties().setDelay(dto.getTimeout());
            return message;
        });
    }
}
