package com.pcloud.book.skill.dao.impl;

import com.pcloud.book.skill.dao.PcloudResourceDao;
import com.pcloud.book.skill.entity.PcloudResource;
import com.pcloud.book.skill.facade.response.QueryPcloudResponseVO;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository("pcloudResourceDao")
public class PcloudResourceDaoImpl extends BaseDaoImpl<PcloudResource> implements PcloudResourceDao {

    @Override
    public int deletePcloudResource(Long id) {
        return super.getSqlSession().update(getStatement("deletePcloudResource"), id);
    }

    @Override
    public QueryPcloudResponseVO getPcloudResource(Long id) {
        return super.getSqlSession().selectOne(getStatement("getPcloudResource"), id);
    }

    @Override
    public Map<Long, PcloudResource> mayByIds(List<Long> ids) {
        return super.getSqlSession().selectMap(getStatement("mayByIds"), ids,"id");
    }
}
