package com.pcloud.book.weixinclock.facade.impl;

import com.pcloud.book.weixinclock.biz.WeixinClockShareBiz;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.cookie.Cookie;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

/**
 * @Describe: 微信群打卡分享接口类
 * @Author: zhangdongwei
 * @Date: Create on 10:21 2019/10/29 0029
 */
@Api(description = "微信群签到打卡分享")
@RestController("weixinClockShareFacade")
@RequestMapping("weixinClockShare")
public class WeixinClockShareFacadeImpl {
    @Autowired
    private WeixinClockShareBiz weixinClockShareBiz;

    /**
     * 获取我的打卡排名
     * @param userInfo
     * @param wxGroupId
     * @param wxUserId
     * @return
     * @throws BizException
     * @throws PermissionException
     */
    @ApiOperation("分享我的排名")
    @ApiImplicitParams({@ApiImplicitParam(name = "wxGroupId", value = "微信群id", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "wxUserId", value = "微信群id", dataType = "string", paramType = "query")})
    @RequestMapping(value = "doShare", method = RequestMethod.GET)
    public ResponseDto<?> doShare(@CookieValue("userInfo") String userInfo,
                                  @RequestParam("wxGroupId") String wxGroupId,
                                  @RequestParam("wxUserId") String wxUserId) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(weixinClockShareBiz.doShare(wechatUserId, wxGroupId, wxUserId));
    }
}
