package com.pcloud.book.rightsSetting.dao.impl;

import cn.hutool.core.map.MapUtil;
import com.pcloud.book.book.vo.BookResourceNumDTO;
import com.pcloud.book.group.dto.BookServeDTO;
import com.pcloud.book.rightsSetting.dao.RightsNowItemDao;
import com.pcloud.book.rightsSetting.entity.RightsNowItem;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2020/4/19 17:44
 **/
@Component("rightsNowItemDao")
public class RightsNowItemDaoImpl  extends BaseDaoImpl<RightsNowItem> implements RightsNowItemDao {
    @Override
    public Integer batchInsert(List<RightsNowItem> list) {
        return super.getSqlSession().insert(getStatement("batchInsert"),list);
    }

    @Override
    public void deleteByRightsSettingId(Long rightsSettingId) {
        super.getSqlSession().delete(getStatement("deleteByRightsSettingId"),rightsSettingId);
    }

    @Override
    public List<RightsNowItem> getListByRightsSettingId(Long rightsSettingId,List<Integer> types) {
        Map<String,Object> map=new HashMap<>();
        map.put("rightsSettingId",rightsSettingId);
        map.put("types",types);
        return super.getSqlSession().selectList(getStatement("getListByRightsSettingId"),map);
    }

    @Override
    public List<RightsNowItem> getGiftCouponListByRightsSettingId(Long rightsSettingId) {
        Map<String,Object> map=new HashMap<>();
        map.put("rightsSettingId",rightsSettingId);
        return super.getSqlSession().selectList(getStatement("getGiftCouponListByRightsSettingId"),map);
    }

    @Override
    public List<RightsNowItem> getListByGroupIds(List<Long> groupIds) {
        Map<String,Object> map=new HashMap<>();
        map.put("groupIds",groupIds);
        return super.getSqlSession().selectList(getStatement("getListByGroupIds"),map);
    }

    @Override
    public List<RightsNowItem> getListByRightsSettingTitleId(Long rightsSettingTitleId, List<Integer> types) {
        Map<String,Object> map=new HashMap<>();
        map.put("rightsSettingTitleId",rightsSettingTitleId);
        map.put("types",types);
        return super.getSqlSession().selectList(getStatement("getListByRightsSettingTitleId"),map);
    }

    @Override
    public List<RightsNowItem> getGiftCouponListByRightsSettingTitleId(Long rightsSettingTitleId) {
        Map<String,Object> map=new HashMap<>();
        map.put("rightsSettingTitleId",rightsSettingTitleId);
        return super.getSqlSession().selectList(getStatement("getGiftCouponListByRightsSettingTitleId"),map);
    }

    @Override
    public List<Long> getAdviserGroupIds(List<Long> ids) {
        return super.getSqlSession().selectList(getStatement("getAdviserGroupIds"), ids);
    }

    @Override
    public List<Long> getActivityGroupIds(List<Long> ids) {
        return super.getSqlSession().selectList(getStatement("getActivityGroupIds"), ids);
    }

    @Override
    public void deleteInvalidNews(List<Long> newsIds) {
        getSqlSession().delete(getStatement("deleteInvalidNews"), newsIds);
    }

    @Override
    public List<RightsNowItem> getByNewsIds(List<Long> newsIds) {
        return getSqlSession().selectList(getStatement("getByNewsIds"), newsIds);
    }

    @Override
    public List<RightsNowItem> getByActivityGroupIds(List<Long> activityIds) {
        return getSessionTemplate().selectList(getStatement("getByActivityGroupIds"), activityIds);
    }

    @Override
    public void deleteInvalidActivityGroups(List<Long> activityIds) {
        getSessionTemplate().delete(getStatement("deleteInvalidActivityGroups"), activityIds);

    }

    @Override
    public List<RightsNowItem> getItemListByRightsSettingId(Long rightsSettingId, Integer rightsNowItemType, Integer readType, Integer openState, String serveType) {
        Map<String, Object> map = new HashMap<>();
        map.put("rightsSettingId", rightsSettingId);
        map.put("rightsNowItemType", rightsNowItemType);
        map.put("readType", readType);
        map.put("openState", openState);
        map.put("serveType", serveType);
        return getSessionTemplate().selectList(getStatement("getItemListByRightsSettingId"), map);
    }

    @Override
    public void deletePackageIds(List<Long> packageIds) {
        getSessionTemplate().delete(getStatement("deletePackageIds"), packageIds);
    }


    @Override
    public List<BookResourceNumDTO> listResourceNum4AdviserBook(List<Long> adviserIds, List<Long> channelIds, List<Long> bookIds) {
        HashMap<String, List<Long>> param = MapUtil.of("adviserIds", adviserIds);
        param.put("channelIds", channelIds);
        param.put("bookIds", bookIds);
        return getSessionTemplate().selectList(getStatement("listResourceNum4AdviserBook"), param);
    }

    @Override
    public List<BookServeDTO> getServeItemsByServeTypes(Long rightsSettingId, List<String> serveTypes, Integer limit) {
        Map<String, Object> map = new HashMap<>();
        map.put("rightsSettingId", rightsSettingId);
        map.put("serveTypes", serveTypes);
        map.put("limit", limit);
        return getSessionTemplate().selectList(getStatement("getServeItemsByServeTypes"), map);
    }

}
