package com.pcloud.common.exceptions;

import com.pcloud.common.exceptions.BizException;

public class FileException extends BizException {

	private static final long serialVersionUID = 1023896160840651020L;

	/**
	 * 文件数量错误
	 */
	public static final int FILE_COUNT_ERROR = 30050000;

	/**
	 * 文件类型错误
	 */
	public static final int FILE_TYPE_ERROR = 30050001;

	/**
	 * 文件内容错误
	 */
	public static final int FILE_CONTENT_ERROR = 30050002;

	/**
	 * 文件不存在
	 */
	public static final int FILE_NOT_EXIST = 30050003;

	/**
	 * 文件读取失败
	 */
	public static final int FILE_READ_FAILURE = 30050004;

	/**
	 * 文件上传失败
	 */
	public static final int FILE_UPLOAD_FAILURE = 30050005;

	/**
	 * XSD校验xml文件失败
	 */
	public static final int XSD_VALIDATE_XML = 30050006;

	/**
	 * 音频文件清晰度解码失败
	 */
	public static final int VIDEO_TRANSFER_FAIL = 30050007;

	/**
	 * 图片压缩失败
	 */
	public static final int IMAGE_COMPRESS_FAIL = 30050008;

	/**
	 * 文件下载失败
	 */
	public static final int FILE_DOWNLOAD_FAILURE = 30050009;

	/**
	 * PDF转换图片失败
	 */
	public static final int PDF_TO_IMAGE_FAIL = 30050010;

	/**
	 * 获取(大)文件上传注册ID失败
	 */
	public static final int FILE_GETFILEID_FAILURE = 30050011;

	/**
	 * 上传文件内容为空
	 */
	public static final int FILE_CONTENT_NOT_EXIST = 30050012;

	/**
	 * 文件上传为完成
	 */
	public static final int FILE_UPLOAD_NOT_FINISH = 30050013;

	/**
	 * 服务器文件删除失败
	 */
	public static final int FILE_DELETE_FAIL = 30050014;

	/**
	 * 文件压缩失败
	 */
	public static final int ZIP_ERROR = 30050015;

	/**
	 * 文件转码失败
	 */
	public static final int FILE_CONVERT_FAIL = 30050016;

	/**
	 * 参数错误
	 */
	public static final int PARAM_ERROR = 30050016;

	public FileException() {

	}

	public FileException(int code, String msgFormat, Object... args) {
		super(code, msgFormat, args);
	}

	public FileException(int code, String msg) {
		super(code, msg);
	}

}
