package com.pcloud.book.adnews.biz;

import com.pcloud.book.adnews.entity.*;
import com.pcloud.book.adnews.dto.AdNewsListParam;
import com.pcloud.book.adnews.vo.AdNewsGroupRecordVO;
import com.pcloud.book.adnews.vo.AdNewsMessageStatisticVO;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;

public interface AdNewsBiz {
    /**
     * 新增早晚报设置
     */
    Long createAdNewsSet(AdNewsSet adNewsSet);

    /**
     * 修改早晚报设置
     */
    void updateAdNewsSet(AdNewsSet adNewsSet);

    /**
     * 发送编辑端早晚报
     */
    void sendAdNews(Long adNewsSetId);

    /**
     * 根据创建人获取早晚报设置
     */
    AdNewsSet getAdNewsSet(Long partyId);

    /**
     * 编辑添加选择的早晚报素材
     */
    void createAdNewsChooseBatch(List<Long> adNewsIds, Long partyId);

    /**
     * 编辑移除选择的早晚报素材
     */
    void deleteAdNewsChoose(Long adNewsId, Long partyId);

    /**
     * 获取素材库列表
     */
    PageBeanNew<AdNews> getAdNewsList(AdNewsListParam adNewsListParam);


    /**
     * 获取编辑已选取的素材库列表
     */
    PageBeanNew<AdNews> getAdNewsChooseList(Long partyId, String title, Boolean hasUsed, Integer currentPage, Integer numPerPage);

    /**
     * 禁用/允许推送
     * @param partyId
     * @param adNewsId
     * @param hasBan
     */
    void saveAdNewsBan( Long partyId, Long adNewsId, Integer hasBan);

    /**
     * 增加公众号反馈
     * @param adNewsWechat
     * @return
     */
    Long addAdNewsWechat(AdNewsWechat adNewsWechat);

    /**
     * 获取所有的公众号列表
     * @param currentPage
     * @param numPerPage
     * @return
     */
    PageBeanNew<AdNewsWechat> getAdNewsWechatList(Integer currentPage, Integer numPerPage);

    /**
     * 获取编辑已选择的公众号列表
     * @param partyId
     * @param currentPage
     * @param numPerPage
     */
    PageBeanNew<AdNewsWechat> getAdNewsWechatChooseList(Long partyId, Integer currentPage, Integer numPerPage);

    /**
     * 编辑添加选择的公众号
     * @param adNewsWechatIds
     * @param partyId
     */
    void createAdNewsWechatChooseBatch(List<Long> adNewsWechatIds, Long partyId);

    /**
     * 编辑移除选择的公众号
     * @param adNewsWechatId
     * @param partyId
     */
    void deleteAdNewsWechatChoose(Long adNewsWechatId, Long partyId);

    /**
     * 获取早晚报发送记录
     * @param partyId
     * @param title
     * @param beginTime
     * @param endTime
     * @param proLabelId 专业
     * @param depLabelId 深度
     * @param purLabelId 目的
     * @param currentPage
     * @param numPerPage
     * @return
     */
    PageBeanNew<AdNewsMessageStatisticVO> getAdNewsMessageStatistic(Long partyId, String title, String beginTime, String endTime, Long proLabelId, Long depLabelId, Long purLabelId, Integer currentPage, Integer numPerPage);

    /**
     * 查询早晚报发送详情
     * @param partyId
     * @param messageStatisticId
     * @return
     */
    List<AdNewsGroupRecordVO> getAdNewsGroupRecord(Long partyId, Long messageStatisticId);

    /**
     * 记录用户点击量
     * @param adNewsClickRecord
     * @return
     */
    Long addAdNewsClickRecord(AdNewsClickRecord adNewsClickRecord);
}
