package com.pcloud.book.book.service.impl;

import com.pcloud.book.book.biz.BookFreezeBiz;
import com.pcloud.book.book.dto.BookFreezeDto;
import com.pcloud.book.book.service.BookFreezeService;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ResponseHandleUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 *   图书冻结内部接口实现类
 * @author lili
 * @date 2018/1/18 19:17
 */
@RestController("bookFreezeService")
@RequestMapping("bookFreezeService")
public class BookFreezeServiceImpl implements BookFreezeService{

    @Autowired
    private BookFreezeBiz bookFreezeBiz;
    @Override
    @RequestMapping(value = "/isFreeze", method = RequestMethod.GET)
    public ResponseEntity<ResponseDto<Boolean>> isFreeze(@RequestParam(value = "bookId", required = false) Long bookId) throws BizException {
        Boolean isFreeze = bookFreezeBiz.isFreeze(bookId);
        return ResponseHandleUtil.toResponse(isFreeze);
    }

    @GetMapping("getById")
    @Override
    public ResponseEntity<ResponseDto<BookFreezeDto>> getById(@RequestParam(value = "bookId", required = false) Long bookId) throws BizException {
        BookFreezeDto bfd = bookFreezeBiz.getById(bookId);

        return ResponseHandleUtil.toResponse(bfd== null? new BookFreezeDto():bfd);
    }
}
