package com.pcloud.book.group.facade.impl;

import com.pcloud.book.group.biz.WeixinQrcodeBiz;
import com.pcloud.book.group.facade.WeixinQrcodeFacade;
import com.pcloud.book.group.vo.QrStatisticsVO;
import com.pcloud.book.group.vo.WeixinQrcodeVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import io.swagger.annotations.ApiOperation;

/**
 * @author lily
 * @date 2019/4/26 15:10
 */
@RestController("weixinQrcodeFacade")
@RequestMapping("weixinQrcode")
public class WeixinQrcodeFacadeImpl implements WeixinQrcodeFacade {

    @Autowired
    private WeixinQrcodeBiz weixinQrcodeBiz;

    @Override
    @PostMapping("addQrcode")
    public ResponseDto<?> addQrcode(@RequestBody WeixinQrcodeVO weixinQrcodeVO) throws BizException{
        weixinQrcodeBiz.addQrcode(weixinQrcodeVO, 0L);
        return new ResponseDto<>();
    }

    @Override
    @GetMapping("getQrStatistics")
    @ApiOperation("平台端获取二维码统计数据")
    public ResponseDto<QrStatisticsVO> getQrStatistics(@RequestHeader("token") String token)
            throws BizException {
        return new ResponseDto<>(weixinQrcodeBiz.getQrStatistics());
    }
}
