package com.pcloud.book.riddle.facade;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.riddle.biz.RiddleRecordBiz;
import com.pcloud.book.riddle.dto.GroupRiddleDTO;
import com.pcloud.book.riddle.dto.RiddleOpenDTO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.wechatgroup.message.dto.SendTextDTO;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * @描述：猜谜语外部接口
 * @作者：zhuyajie
 * @创建时间：17:53 2019/7/26
 * @版本：1.0
 */
@Api(description = "猜谜语外部接口")
@RequestMapping(value = "/riddle")
@RestController("riddleFacade")
public class RiddleFacade {

    @Autowired
    private RiddleRecordBiz riddleRecordBiz;

    @ApiOperation("发送信息")
    @PostMapping("sendText")
    public ResponseDto<?> sendText(@RequestBody @ApiParam SendTextDTO sendTextDTO){
        riddleRecordBiz.riddleProcess(sendTextDTO);
        return new ResponseDto<>();
    }

    @ApiOperation("猜谜语详情列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "name", value = "name", required = false, dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "currentPage", value = "当前页", required = true, dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", required = true, dataType = "int", paramType = "query"),
    })
    @GetMapping("listPage")
    public ResponseDto<PageBeanNew<GroupRiddleDTO>> listPage(
            @RequestHeader("token") String token, @RequestParam(value = "name", required = false) String name,
            @RequestParam("currentPage") Integer currentPage, @RequestParam("numPerPage") Integer numPerPage) throws PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        if (null == numPerPage || null == currentPage) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "分页参数缺失");
        }
        PageBeanNew<GroupRiddleDTO> pageBean = riddleRecordBiz.listPage(partyId, currentPage, numPerPage, name);
        return new ResponseDto<>(pageBean);
    }

    @ApiOperation("更新猜谜语状态")
    @PostMapping("updateRiddleOpenStatus")
    public ResponseDto<?> updateRiddleOpenStatus(@RequestHeader("token") String token, @RequestBody @ApiParam RiddleOpenDTO riddleOpenDTO) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        if (null == riddleOpenDTO) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "参数缺失");
        }
        Long qrcodeId = riddleOpenDTO.getGroupQrcodeId();
        Boolean status = riddleOpenDTO.getStatus();
        if (null == qrcodeId || null == status) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "参数缺失");
        }
        riddleRecordBiz.updateRiddleOpenStatus(qrcodeId, status);
        return new ResponseDto<>();
    }
}
