package com.pcloud.book.riddle.redis;

import com.pcloud.book.riddle.constants.RiddleConstant;
import com.pcloud.book.riddle.dto.GroupRedisDTO;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.cache.redis.JedisClusterUtils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @描述：猜谜语缓存
 * @作者：zhuyajie
 * @创建时间：10:55 2019/7/30
 * @版本：1.0
 */
@Component("riddleRedis")
public class RiddleRedis {
    private static final Logger logger = LoggerFactory.getLogger(RiddleRedis.class);

    public static final String prefix = "BOOK_RIDDLE";
    public static final String wait_time = prefix + "_wait_time";//到时间回复信息
    public static final String underway_group = prefix+"_underway_group";//答题中的群

    /**
     * 添加等待时间
     * @param wxGroupId
     * @param value
     */
    public void addWaitTime(String wxGroupId, String value) {
        String key = wait_time + wxGroupId;
        JedisClusterUtils.set(key, value);
        JedisClusterUtils.expire(key, RiddleConstant.expire_seconds);
    }

    /**
     * 获取等待时间
     * @param wxGroupId
     * @return
     */
    public String getWaitTime(String wxGroupId) {
        String key = wait_time + wxGroupId;
        return JedisClusterUtils.get(key);
    }

    /**
     * 添加答题中的群
     * @param wxGroupId
     */
    public void addUnderwayGroup(String wxGroupId, String wxId, String ip) {
        GroupRedisDTO dto = new GroupRedisDTO();
        dto.setWxGroupId(wxGroupId);
        dto.setWxId(wxId);
        dto.setIp(ip);
        List<GroupRedisDTO> list = getUnderwayGroup();
        if (ListUtils.isEmpty(list)) {
            list = new ArrayList<>();
            list.add(dto);
        } else {
            if (!list.contains(dto)) {
                list.add(dto);
            }
        }
        JedisClusterUtils.setJsonList(underway_group, list);
    }

    /**
     * 获取答题中的群
     * @return
     */
    public List<GroupRedisDTO> getUnderwayGroup() {
        List<GroupRedisDTO> list = JedisClusterUtils.getJsonList(underway_group, GroupRedisDTO.class);
        if (ListUtils.isEmpty(list)) {
            list = new ArrayList<>();
            GroupRedisDTO dto = new GroupRedisDTO();
            dto.setWxGroupId("1");
            dto.setWxId("1");
            dto.setIp("1");
            list.add(dto);
            JedisClusterUtils.setJsonList(underway_group, list);
        }
        return list;
    }

    /**
     * 删除答题中的群
     * @param wxGroupId
     */
    public void deleteUnderwayGroup(String wxGroupId) {
        List<GroupRedisDTO> list = getUnderwayGroup();
        if (!ListUtils.isEmpty(list)) {
            for (int i = 0; i < list.size() && null != list; i++) {
                GroupRedisDTO dto = list.get(i);
                if (null != dto && dto.getWxGroupId().equals(wxGroupId)) {
                    list.remove(dto);
                }
            }
        }
        if (ListUtils.isEmpty(list)) {
            list = new ArrayList<>();
            GroupRedisDTO dto = new GroupRedisDTO();
            dto.setWxGroupId("1");
            dto.setWxId("1");
            dto.setIp("1");
            list.add(dto);
        }
        JedisClusterUtils.setJsonList(underway_group, list);
    }

}
