package com.pcloud.book.advertising.dao.impl;

import com.pcloud.book.advertising.dao.AdvertisingExposureRecordDao;
import com.pcloud.book.advertising.entity.AdvertisingExposureRecord;
import com.pcloud.book.group.dto.AdGroupQrcodeDTO;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Description 广告位曝光记录数据访问层接口实现类
 * @author PENG
 * @date 2019/2/28
 */
@Repository("advertisingExposureRecordDao")
public class AdvertisingExposureRecordDaoImpl extends BaseDaoImpl<AdvertisingExposureRecord> implements AdvertisingExposureRecordDao {

    /**
     * 获取广告位投放微信群曝光量前几位
     */
    @Override
    public List<AdGroupQrcodeDTO> advertisingWechatGroupRankTop() {
        return super.getSqlSession().selectList(getStatement("advertisingWechatGroupRankTop"));
    }

    @Override
    public void updateExposureByQrcode(Long qrcodeId, Integer peopleCounts) {
        Map<String, Object> map = new HashMap<>();
        map.put("fromId", qrcodeId);
        map.put("count", peopleCounts);
        getSessionTemplate().update(getStatement("updateExposureByQrcode"), map);
    }
}
