package com.pcloud.book.keywords.dao.impl;

import com.pcloud.book.keywords.dao.BookGuideReplyDao;
import com.pcloud.book.keywords.entity.BookGuideReply;
import com.pcloud.book.keywords.vo.ReplyMessageVO;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2019/4/23 16:06
 */
@Component("bookGuideReplyDao")
public class BookGuideReplyDaoImpl extends BaseDaoImpl<BookGuideReply> implements BookGuideReplyDao {

    @Override
    public void deleteByGuideId(Long bookGuideId) {
        this.getSqlSession().update(this.getStatement("deleteByGuideId"), bookGuideId);
    }

    @Override
    public List<ReplyMessageVO> getReplyMessage(Long guideId) {
        return this.getSqlSession().selectList(this.getStatement("getReplyMessage"), guideId);
    }

    @Override
    public void updateServeInfo(Long serveId, String serveType, String title, String squareImg) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("serveId", serveId);
        paramMap.put("serveType", serveType);
        paramMap.put("content", title);
        paramMap.put("picUrl", squareImg);
        this.getSqlSession().update(this.getStatement("updateServeInfo"), paramMap);
    }
}
