package com.pcloud.common.core.biz;

import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.core.constant.MQQueueConstant;
import com.pcloud.common.core.dto.BacklogQueueDto;
import com.pcloud.common.exceptions.BizException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @描述：待办事务统计
 * @作者：zhuyajie
 * @创建时间：10:46 2018/10/31
 * @版本：1.0
 */
@Component("backlogQueueBiz")
public class BacklogQueueBizImpl implements BacklogQueueBiz {
    private final static Logger logger = LoggerFactory.getLogger(BacklogQueueBizImpl.class);

    @Autowired
    private AmqpTemplate amqpTemplate;

    @Override
    @ParamLog("发送待办事务通知")
    public void sendBacklogQueue(BacklogQueueDto backlogQueueDto) throws BizException{
        if (backlogQueueDto == null) {
            throw BizException.PARAM_IS_NULL;
        }
        try {
             amqpTemplate.convertAndSend(MQQueueConstant.BACKLOG, backlogQueueDto);
        } catch (Exception e) {
            logger.error("发送失败，" + e.getMessage() + "," + backlogQueueDto.toString(), e);
            throw BizException.SEND_QUEUE_FAIL;
        }
    }
}
