package com.pcloud.common.core.constant;


/**
 * @描述： 漏斗流程常量结构体
 * @作者： shuyh
 * @创建时间： 2018年1月8日
 * @版本：1.0
 */
public class FunnelFlowStruct {
	
	protected enum FlowType { 
		REGIST(1, "REGIST", "注册", "注册流程", 1), 
		TASK(2, "TASK", "任务", "任务流程", 2);
	    private long id;
	    private String code;
	    private String name;
	    private String desc;
	    private long orderNo;
		private FlowType(long id, String code, String name, String desc, long orderNo) {
			this.id = id;
			this.code = code;
			this.name = name;
			this.desc = desc;
			this.orderNo = orderNo;
		}
		public long getId() {
			return id;
		}
		public String getCode() {
			return code;
		}
		public String getName() {
			return name;
		}
		public String getDesc() {
			return desc;
		}
		public long getOrderNo() {
			return orderNo;
		}
	}

	protected enum Flow {
		REGIST_ACCOUNT(1, "REGIST_ACCOUNT", "账户注册", "账户注册流程", FlowType.REGIST.id, 1);
		private long id;
	    private String code;
	    private String name;
	    private String desc;
	    private long typeId;
	    private long orderNo;
		private Flow(long id, String code, String name, String desc,
				long typeId, long orderNo) {
			this.id = id;
			this.code = code;
			this.name = name;
			this.desc = desc;
			this.typeId = typeId;
			this.orderNo = orderNo;
		}
		public long getId() {
			return id;
		}
		public String getCode() {
			return code;
		}
		public String getName() {
			return name;
		}
		public String getDesc() {
			return desc;
		}
		public long getTypeId() {
			return typeId;
		}
		public long getOrderNo() {
			return orderNo;
		}
	}
	
	public enum FlowNode { 
		REGIST_ACCOUNT$1LANDING_NODE(1, "LANDING", "起始页", "起始页", Flow.REGIST_ACCOUNT.id, 1),
		REGIST_ACCOUNT$2SMSVERIFY_NODE(2, "SMS_VERIFY", "手机短信验证", "手机短信验证", Flow.REGIST_ACCOUNT.id, 2),
		REGIST_ACCOUNT$3REGIST_NODE(3, "REGIST", "账户注册", "账户注册", Flow.REGIST_ACCOUNT.id, 3);
		private long id;
	    private String code;
	    private String name;
	    private String desc;
	    private long flowId;
	    private long orderNo;
		private FlowNode(long id, String code, String name, String desc,
				long flowId, long orderNo) {
			this.id = id;
			this.code = code;
			this.name = name;
			this.desc = desc;
			this.flowId = flowId;
			this.orderNo = orderNo;
		}
		public long getId() {
			return id;
		}
		public String getCode() {
			return code;
		}
		public String getName() {
			return name;
		}
		public String getDesc() {
			return desc;
		}
		public long getFlowId() {
			return flowId;
		}
		public long getOrderNo() {
			return orderNo;
		}
	}
	
	public enum TargetType { 
		ACCOUNT, APP, PRODUCT
	}
	
	public enum TargetRoleType { 
		MERCHANT, ADVISER, CHANNEL, OFFICIAL_ACCOUNTS, AGENT, ADMIN
	}
	
}
