package com.pcloud.book.copyright.vo;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * @author lily
 * @date 2018/12/3 15:45
 */
@ApiModel
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ListAllBookServeParam implements Serializable {

    @ApiModelProperty("当前页")
    private Integer currentPage;

    @ApiModelProperty("每页条数")
    private Integer numPerPage;

    @ApiModelProperty("服务名称")
    private String serveName;

    @ApiModelProperty("类型（PRODUCT/APP）")
    private String typeCode;

    @ApiModelProperty("具体类型编码")
    private String fromType;

    public Integer getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public Integer getNumPerPage() {
        return numPerPage;
    }

    public void setNumPerPage(Integer numPerPage) {
        this.numPerPage = numPerPage;
    }

    public String getServeName() {
        return serveName;
    }

    public void setServeName(String serveName) {
        this.serveName = serveName;
    }

    public String getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public String getFromType() {
        return fromType;
    }

    public void setFromType(String fromType) {
        this.fromType = fromType;
    }

    @Override
    public String toString() {
        return "ListAllBookServeParamVO{" +
                "currentPage=" + currentPage +
                ", numPerPage=" + numPerPage +
                ", serveName='" + serveName + '\'' +
                ", typeCode='" + typeCode + '\'' +
                ", fromType='" + fromType + '\'' +
                '}';
    }
}
