package com.pcloud.book.group.facade.impl;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.group.biz.GroupAnnouncementBiz;
import com.pcloud.book.group.entity.GroupAnnouncement;
import com.pcloud.book.group.facade.GroupAnnouncementFacade;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/5/24 16:29
 **/
@RestController("groupAnnouncementFacade")
@RequestMapping("groupAnnouncement")
public class GroupAnnouncementFacadeImpl implements GroupAnnouncementFacade {

    @Autowired
    private GroupAnnouncementBiz groupAnnouncementBiz;


    @ApiOperation("新增群公告")
    @PostMapping("createGroupAnnouncement")
    @Override
    public ResponseDto<?> createGroupAnnouncement(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("群公告实体") GroupAnnouncement groupAnnouncement
    ) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        if (groupAnnouncement==null){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"群公告实体不能为空！");
        }
        groupAnnouncement.setCreateUser(partyId);
        groupAnnouncement.setUpdateUser(partyId);
        return new ResponseDto<>(groupAnnouncementBiz.createGroupAnnouncement(groupAnnouncement));
    }

    @ApiOperation("修改群公告")
    @PostMapping("updateGroupAnnouncement")
    @Override
    public ResponseDto<?> updateGroupAnnouncement(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("群公告实体") GroupAnnouncement groupAnnouncement
    ) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        if (groupAnnouncement==null){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"群公告实体不能为空！");
        }
        groupAnnouncement.setUpdateUser(partyId);
        groupAnnouncementBiz.updateGroupAnnouncement(groupAnnouncement);
        return new ResponseDto<>();
    }

    @ApiOperation("获取群公告")
    @GetMapping("getGroupAnnouncement")
    @Override
    public ResponseDto<?> getGroupAnnouncement(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam(value = "classifyId",required = false) @ApiParam("分类id") Long classifyId,
            @RequestParam(value = "bookGroupId",required = false) @ApiParam("社群码id") Long bookGroupId
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(groupAnnouncementBiz.getGroupAnnouncement(classifyId,bookGroupId));
    }
}
