package com.pcloud.book.advertising.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;

import java.util.Date;

import lombok.Data;

/**
 * @描述：链接转换记录
 * @作者：zhuyajie
 * @创建时间：17:13 2019/10/10
 * @版本：1.0
 */
@Data
public class LinkRevertRecordDTO extends BaseDto {

    /**
     * 记录id
     */
    private Long id;
    /**
     *品牌方id
     */
    private Long brandId;

    /**
     * 品牌方名称
     */
    private String brandName;
    /**
     *原链接
     */
    private String link;
    /**
     *短链接
     */
    private String shortLink;
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date createTime;
    /**
     * 发送次数
     */
    private Integer sendCount;
    /**
     * 点击次数
     */
    private Integer clickCount;
    /**
     * 点击人数
     */
    private Integer clickUserCount;
    /**
     * 发送次数变化
     */
    private Integer sendCountChange;
    /**
     *点击次数变化
     */
    private Integer clickCountChange;
    /**
     *点击人数变化
     */
    private Integer clickUserCountChange;


}
