package com.pcloud.book.appeal.dao.impl;

import java.util.List;

import org.springframework.stereotype.Repository;

import com.pcloud.book.appeal.dao.BookAppealDao;
import com.pcloud.book.appeal.dto.BookAppealDto;
import com.pcloud.book.appeal.entity.BookAppeal;
import com.pcloud.common.core.dao.BaseDaoImpl;

/** 
  *  书刊申诉数据访问层实现类
  *  @author:lili
  *  @date 创建时间：2017年3月30日 下午4:17:11 
  *  @version 1.0 
  *  @return  
  */
@Repository("bookAppealDao")
public class BookAppealDaoImpl extends BaseDaoImpl<BookAppeal> implements BookAppealDao{

	/**
	 * 获取申诉详情
	 */
	@Override
	public BookAppealDto getById(Long bookAppealId) {
		return this.getSqlSession().selectOne(this.getStatement("getById"),bookAppealId);
	}

	/**
	 * 获取所有被诉编辑
	 */
	@Override
	public List<BookAppealDto> getAppealAdvisers(Long bookAppealId) {
		return this.getSqlSession().selectList(this.getStatement("getAppealAdvisers"),bookAppealId);
	}

}
