package com.pcloud.book.applet.dao;

import com.pcloud.book.applet.dto.AppletRecordStatisDTO;
import com.pcloud.book.applet.dto.ReadBookDayStatisDTO;
import com.pcloud.book.applet.entity.AppletRecordStatis;
import com.pcloud.common.core.dao.BaseDao;

import java.util.Date;
import java.util.List;

/**
 * 小睿小程序点击量统计(AppletRecordStatis)表数据库访问层
 *
 * @author makejava
 * @since 2020-12-10 17:58:06
 */
public interface AppletRecordStatisDao extends BaseDao<AppletRecordStatis> {

    /**
     * 每个应用、作品点击量详情
     */
    List<AppletRecordStatisDTO> getBookSourceWeekStatis(Long wechatUserId, Date mondayDate);

    /**
     * 本周的应用作品总点击量
     */
    Integer getBookSourceTotalClickCount(Long wechatUserId, Date mondayDate);

    List<AppletRecordStatisDTO> getBookNewsWeekStatics(Long wechatUserId, Date mondayDate);

    Integer getBookNewsTotalClickCount(Long wechatUserId, Date mondayDate);

    void addWeekAppletRecordStatis4App(Date prevMonday, Date prevSunday, Long limitStart, Long limitNumber);

    void addWeekAppletRecordStatis4News(Date prevMonday, Date prevSunday, Long limitStart, Long limitNumber);

    void deleteWeekAppletRecordStatis(String monday);
}
