/**
 * 
 */
package com.pcloud.book.consumer.analysisengine;

import com.pcloud.analysisengine.qrcode.service.BookScanCountService;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @描述：书籍统计中间件
 * @作者：lili
 * @创建时间：2016年12月14日,下午5:36:04 @版本：1.0
 */
@Component("bookScanCountConsr")
public class BookScanCountConsr {

	/**
	 * logger
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(BookScanCountConsr.class);

	@Autowired
	private BookScanCountService bookScanCountService;

	/**
	 * 获取书籍扫描数
	 */
	public Map<String, Long> listBookScanCount(List<Long> bookIds, List<Long> channelIds, Long adviserId)
			throws BizException {
		LOGGER.info("【二维码-渠道(消)】获取书籍扫描数,<START>.[bookIds]=" + bookIds + ",[channelIds]=" + channelIds + ",[adviserId]="
				+ adviserId);
		Map<String, Long> bookScanCount = new HashMap<>();
		if (ListUtils.isEmpty(bookIds) || ListUtils.isEmpty(channelIds) || adviserId == null) {
			LOGGER.warn("参数缺失~！");
			return bookScanCount;
		}
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("bookIds", bookIds);
		paramMap.put("channelIds", channelIds);
		try {
			bookScanCount = ResponseHandleUtil.parseMapResponse(
					bookScanCountService.listBookScanCount(paramMap, adviserId), String.class, Long.class);
		}catch (BizException e) {
			LOGGER.warn("【二维码-渠道(消)】获取书籍扫描数,<ERROR>.[create]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("【二维码-渠道(消)】获取书籍扫描数,<ERROR>.[create]:" + e.getMessage(), e);
		}
		return bookScanCount;
	}

}
