package com.pcloud.book.group.biz.impl;

import cn.hutool.core.util.StrUtil;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.group.biz.BizMaterialBiz;
import com.pcloud.book.group.biz.GroupMaterialAccountBiz;
import com.pcloud.book.group.entity.BizMaterial;
import com.pcloud.book.group.entity.GroupMaterialAccount;
import com.pcloud.book.group.enums.UseTypeEnum;
import com.pcloud.book.group.mapper.BizMaterialMapper;
import com.pcloud.common.utils.QrcodeUtils;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.facade.wechat.material.dto.GroupNewsMaterialAddDTO;
import com.pcloud.facade.wechat.material.service.MaterialService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.Objects;

@Component("bizMaterialBiz")
public class BizMaterialBizImpl implements BizMaterialBiz {

    public static final String THIRD_RESOURCE_MATERIAL_HTML_TEMPLATE = "<div style='margin:10px 0;box-sizing: border-box;'><div style='margin:55px auto 32px;width: 275px;height: 255px;'><div style='width: 275px;height: 255px;background-color: #ffffff;border-radius: 6px;border: solid 1px #66c84f'><div style='margin-top:-16px;margin-left:53px;width: 168px;height: 32px;line-height: 32px;text-align: center; font-size: 14px;color: #ffffff; background-color: #66c84f;border-radius: 6px;'>长按识别下面二维码</div><div style='height: 23px;display: block;text-align: center;margin: 10px auto;letter-spacing: 6px;'>\uD83D\uDC47\uD83D\uDC47\uD83D\uDC47</div><div style='width: 172px;height:172px;display: block;margin: 0 auto;'><img class='qrcode'src='${qrcodeUrl}'alt=''></div></div></div></div>";

    @Autowired
    private BizMaterialMapper bizMaterialMapper;
    @Autowired
    private GroupMaterialAccountBiz groupMaterialAccountBiz;
    @Autowired
    private MaterialService materialService;

    @Override
    public void createMaterial4ThirdResource(String name, String link, Integer resourceId) {

        String qrcodeUrl = QrcodeUtils.create(link);
        GroupMaterialAccount account = groupMaterialAccountBiz.getActiveAccount(UseTypeEnum.THIRD_GROUP.value);
        if (null == account) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "公众号素材不足，请联系管理员");
        }

        GroupNewsMaterialAddDTO groupNewsMaterialAddDTO = new GroupNewsMaterialAddDTO();
        groupNewsMaterialAddDTO.setGroupName(name);
        groupNewsMaterialAddDTO.setQrcodeUrl(qrcodeUrl);
        // 存在则更新
        BizMaterial material = bizMaterialMapper.getByBizId(resourceId,UseTypeEnum.THIRD_GROUP.value);
        if (Objects.nonNull(material)){
            groupNewsMaterialAddDTO.setMediaId(material.getMediaId());
        }
        groupNewsMaterialAddDTO.setAccountId(account.getAccountId());
        groupNewsMaterialAddDTO.setCoverMediaId(account.getCoverMediaId());
        groupNewsMaterialAddDTO.setHtml(THIRD_RESOURCE_MATERIAL_HTML_TEMPLATE);
        groupNewsMaterialAddDTO.setGroupHeadImg(account.getHeadMediaId());
        String mediaId = ResponseHandleUtil.parseResponse(materialService.getGroupNewsMaterial(groupNewsMaterialAddDTO), String.class);
        if (StrUtil.isBlank(mediaId)) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "公众号素材不足，请联系管理员");
        }
        String materialUrl = ResponseHandleUtil.parseResponse(materialService.getGroupNewsMaterialByMediaId(mediaId), String.class);
        if (StrUtil.isBlank(materialUrl)) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "公众号素材不足，请联系管理员");
        }
        BizMaterial bizMaterial = new BizMaterial();
        bizMaterial.setAccountId(Math.toIntExact(account.getId()));
        bizMaterial.setBizId(resourceId);
        bizMaterial.setBizType(UseTypeEnum.THIRD_GROUP.value);
        bizMaterial.setCreateTime(new Date());
        bizMaterial.setMaterialUrl(materialUrl);
        bizMaterial.setMediaId(mediaId);
        bizMaterialMapper.insertOrUpdate(bizMaterial);
    }

    @Override
    public boolean materialExists(Long id, Integer type) {
        BizMaterial byBizId = bizMaterialMapper.getByBizId(Math.toIntExact(id), type);
        return Objects.nonNull(byBizId) && Objects.nonNull(byBizId.getId());
    }
}
